<?php 
require_once 'global.php'; # Solo una ves se requiere

$conexion = new mysqli(DB_HOST, DB_USERNAME, DB_PASSWORD, DB_NAME);

mysqli_query( $conexion, 'SET NAMES "'.DB_ENCODE.'"');

mysqli_set_charset($conexion, DB_ENCODE); #Establece el conjunto de caracteres predeterminado del cliente.

#Si tenemos un posible error en la conexión lo mostramos
if($conexion->connect_errno){
#if (mysqli_connect_errno($conexion)){
  printf(PRO_NOMBRE." - Falló conexión a la base de datos ".DB_NAME.": %s\n", mysqli_connect_error());
  validaConn();
  exit();
}

if (!function_exists('ejecutarConsulta')){
  
  function ejecutarConsulta($query){
    global $conexion;
    $query = $conexion->query($query);
    return $query;
  }
  
  function ejecutarConsultaRetornaFila($query){
    #Retorna conjunto de datos relacionados a un ID
    #Requeire php json_encode y javascrip data = JSON.parse(data);
    global $conexion;
    $query = $conexion->query($query);
    $row = $query->fetch_assoc();
    return $row;
  }
  
  function ejecutarConsultaRetornaFilaCampo($query){
    #Retorna conjunto de datos relacionados a un ID se especifica campo(s) a obtener $row->campos;
    global $conexion;
    $query = $conexion->query($query);
    $row = $query->fetch_object();
    return $row;
  }
  
  function ejecutarConsultaRetornarID($query){ #Retorna el ID de una insercion reciente.
    global $conexion;
    $conexion->query( $query );
    return $conexion->insert_id;
  }
  
  function limpiarCadena($str){
    global $conexion;
    $str2 = mysqli_real_escape_string( $conexion, trim($str) );
    return htmlspecialchars($str2);
  }
  
  function POST($NombreVariable){
    if( is_array( filter_input(INPUT_POST, $NombreVariable, FILTER_DEFAULT, FILTER_REQUIRE_ARRAY) ) ) {
      return filter_input(INPUT_POST, $NombreVariable, FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);
    }else{
      $NombreVariable = limpiarCadena( filter_input(INPUT_POST, $NombreVariable));
      return htmlspecialchars($NombreVariable);
    }
  }
  
  function GET($NombreVariable){
    $NombreVariable2 = limpiarCadena( filter_input(INPUT_GET, $NombreVariable));
    return htmlspecialchars($NombreVariable2);
  }
  
  function validaConn(){
    echo "<br />conexion = new mysqli(".DB_HOST.", ".DB_USERNAME.", ".DB_PASSWORD.", ".DB_NAME.");";
    
    $validaConn = mysqli_connect(DB_HOST, DB_USERNAME, DB_PASSWORD, DB_NAME);
    echo "<br />Conexion exitosa ".PRO_NOMBRE." de la base de datos (". DB_NAME .") <br>Parametros: ". mysqli_get_host_info($validaConn) . "\n <br>";
    mysqli_close($validaConn);
    
    
    echo "<hr /><br />mysqli_connect(".DB_HOST.", ".DB_USERNAME.", ".DB_PASSWORD.", ".DB_NAME.");";
    #Validacion de conexion anteriroes...
    $enlace = mysqli_connect(DB_HOST, DB_USERNAME, DB_PASSWORD, DB_NAME);
    
    if (!$enlace) {
      echo "<br />Error: No se pudo conectar a MySQL ( ".DB_NAME." ):" . PHP_EOL;
      echo "<br />errno de depuración: " . mysqli_connect_errno() . PHP_EOL;
      echo "<br />error de depuración: " . mysqli_connect_error() . PHP_EOL;
      exit;
    }
    
    echo "<br />Éxito: Se realizó una conexión apropiada a MySQL! ( ".DB_NAME." ): La base de datos mi_bd es genial." . PHP_EOL;
    echo "<br />Información del host: " . mysqli_get_host_info($enlace) . PHP_EOL;
    mysqli_close($enlace);    
  }
  
}else{
  echo 'Error archivo Conexion PHP.';
}

#echo '<br />config/Conexion.php Linea Final.';
?>