<?php 
#Incluímos inicialmente la conexión a la base de datos
require_once "../config/Conexion.php";

Class BuscaVenta{
  
  #Variables para nombres generales en el Modelo...
  public $tablaDB = "venta";
  private $caracteres_malos = array("'", '"', '<', '>', '\\', '/', '#', '%', '&', '¿','?', '|');
  
  public function __construct(){ }  
    
  public function Buscar($control, $fechainicio, $fechafin, $VerSQL=false){
    if(is_numeric($control) AND $control !== ''){
      $control = "AND a.idventa LIKE '%$control%' ";
    }
    if($fechainicio!=='' AND $fechafin!==''){
      $cf = "AND DATE(a.fecha) BETWEEN '$fechainicio' AND '$fechafin' ";
    }elseif($fechainicio!=='' AND $fechafin===''){
      $cf = "AND DATE(a.fecha) = '$fechainicio' ";
    }
    
    $query = "SELECT a.*, TIMESTAMPDIFF(month, a.fecha, NOW()) AS mesf, b.nombre "
            . "FROM $this->tablaDB a "
            . "INNER JOIN usuario b ON a.idusuario = b.idusuario "
            . "WHERE a.total LIKE '%' "
            . "$control $cf"
            . "AND a.idcontrol = '".$_SESSION['idcontrol']."' ";
    
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }
  }
  
  public function BuscarMovil($control, $fechainicio, $fechafin, $VerSQL=false){
    if(is_numeric($control) AND $control !== ''){
      $control = "AND `a`.`idventa` = '$control' ";
    }
    if($fechainicio!=='' AND $fechafin!==''){
      $cf = "AND DATE(`a`.`fecha`) BETWEEN '$fechainicio' AND '$fechafin' ";
    }elseif($fechainicio!=='' AND $fechafin===''){
      $cf = "AND DATE(`a`.`fecha`) = '$fechainicio' ";
    }
    
    $query = "SELECT `a`.*, TIMESTAMPDIFF(month, `a`.`fecha`, NOW()) AS mesf, `b`.`nombre` "
            . "FROM `$this->tablaDB` `a` "
            . "INNER JOIN `usuario` `b` ON `a`.`idusuario` = `b`.`idusuario` "
            . "WHERE `a`.`total` LIKE '%' "
            . "$control $cf"
            . "AND `a`.`idcontrol` = '".$_SESSION['idcontrol']."' "
            . "ORDER BY `a`.`idventa` DESC;";
    
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }
  }
  
  public function listaEventos($idRegistro, $VerSQL=false){    
    $query = "SELECT a.idproducto, a.cantidad, a.subtotal, a.iva, a.total, b.codigosat, b.marca, b.producto, c.fecha, "
            . "c.td, c.ttd, c.codaceptacion, c.multipago, c.descuento, c.total AS ventatotal, d.nombre "
            . "FROM producto_venta a "
            . "INNER JOIN producto b ON a.idproducto = b.idproducto "
            . "INNER JOIN venta c ON a.idventa = c.idventa "
            . "INNER JOIN usuario d ON c.idusuario = d.idusuario "
            . "WHERE a.idventa = '$idRegistro' "
            . "AND a.idcontrol = '".$_SESSION['idcontrol']."' "
            . "AND b.idcontrol = '".$_SESSION['idcontrol']."' "
            . "AND c.idcontrol = '".$_SESSION['idcontrol']."' ";
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }
  }
  
  public function validaRFC($rfc){
    if(strlen($rfc) < 10 ){
      $where = "WHERE idcontribuyente LIKE '$rfc%' ";
    }else{
      $where = "WHERE idcontribuyente = '$rfc' LIMIT 1 ";
    }
    
   $query = "SELECT * "
            . "FROM contribuyente "
            . "$where";            
    return ejecutarConsulta($query);
  }
  
  public function insertarContribuyente($idcontribuyente, $nombre, $direccion, $correo, $correodos){
    #Trabajar variables recibidas    
    $nombre = str_replace($this->caracteres_malos, '', $nombre);
    $idcontribuyente = str_replace($this->caracteres_malos, '', $idcontribuyente);
    $direccion = str_replace($this->caracteres_malos, '', $direccion);
    
    $query = "INSERT INTO contribuyente (idcontribuyente, nombre, direccion, correo, correodos) "
            . "VALUES ('$idcontribuyente', '$nombre', '$direccion', '$correo', '$correodos');";  
    
    return ejecutarConsulta($query);
  }
  
  public function editarContribuyente($existerfc, $idcontribuyente, $nombre, $direccion, $correo, $correodos){
    $nombre = str_replace($this->caracteres_malos, '', $nombre);
    $idcontribuyente = str_replace($this->caracteres_malos, '', $idcontribuyente);
    $direccion = str_replace($this->caracteres_malos, '', $direccion);
    $correo = str_replace($this->caracteres_malos, '', $correo);
    $correodos = str_replace($this->caracteres_malos, '', $correodos);
    
    $query = "UPDATE contribuyente "
	    . "SET idcontribuyente='$idcontribuyente', nombre='$nombre', direccion='$direccion', correo='$correo', "
            . "correodos='$correodos' "
	    . "WHERE idcontribuyente = '$existerfc' ";
    return ejecutarConsulta($query);
  }
  
  public function solicitaFacturaVenta($idventa, $rfc, $usocfdi) {
    #Estado 0=Espera 1=Facturado 2=Cancelado
    $query = "UPDATE venta "
	    . "SET idcontribuyente='$rfc', usocfdi='$usocfdi', estado='0' "
	    . "WHERE idventa = '$idventa' "
          . "AND idcontrol = '".$_SESSION['idcontrol']."' ";
    return ejecutarConsulta($query);
  }
} ?>