<?php 
#Incluímos inicialmente la conexión a la base de datos
require_once "../config/Conexion.php";

Class ReporteCaduciad{
  
  #Variables para nombres generales en el Modelo...
  public $tablaDB = "resurtir";
  private $caracteres_malos = array("'", '"', '<', '>', '\\', '/', '#', '%', '&', '¿','?', '|');
  
  public function __construct(){ }  
    
  public function listaEventos($fi, $ff, $VerSQL=false){    
    $query = "SELECT a.`idresurtir`, a.`idproducto`, a.`cantidad`, a.`existencia`, a.`caducidad`, "
            . "TIMESTAMPDIFF(DAY, NOW(), a.`caducidad`) AS faltan, b.`marca`, b.`producto` "
            . "FROM `$this->tablaDB` a "
            . "INNER JOIN `producto` b ON a.`idproducto` = b.`idproducto` "
            . "WHERE a.`existencia` > 0 "
            . "AND a.`caducidad` IS NOT NULL "
            . "AND TIMESTAMPDIFF(DAY, NOW(), a.`caducidad`) > $fi "
            . "AND TIMESTAMPDIFF(DAY, NOW(), a.`caducidad`) < $ff "
            . "AND a.`idcontrol` = '".$_SESSION['idcontrol']."' "
            . "AND b.`idcontrol` = '".$_SESSION['idcontrol']."' "
            . "ORDER BY TIMESTAMPDIFF(DAY, NOW(), a.`caducidad`) ASC; ";    
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }
  }
  
  public function listaEventosYaCaduco($fi, $ff, $VerSQL=false){    
    $query = "SELECT a.`idresurtir`, a.`idproducto`, a.`cantidad`, a.`existencia`, a.`caducidad`, "
            . "TIMESTAMPDIFF(DAY, NOW(), a.`caducidad`) AS faltan, b.`marca`, b.`producto` "
            . "FROM `$this->tablaDB` a "
            . "INNER JOIN `producto` b ON a.`idproducto` = b.`idproducto` "
            . "WHERE a.`existencia` < 0 "
            . "AND a.`caducidad` IS NOT NULL "
            . "AND a.`fecha` BETWEEN '$fi' AND '$ff' "
            . "AND a.`idcontrol` = '".$_SESSION['idcontrol']."' "
            . "AND b.`idcontrol` = '".$_SESSION['idcontrol']."' "
            . "ORDER BY a.`fecha`, a.`caducidad` ASC; ";    
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }
  }
  
  public function retiraResurtir($idresurtir, $producto, $cantidad) {
    $cantidad = $cantidad * -1;
    $query = "UPDATE `$this->tablaDB` "
            . "SET `existencia` = '$cantidad' "
            . "WHERE `idresurtir` = '$idresurtir'; ";
    
    #Guardar accion en bitacora para llevar un registro.
    $queryBi = str_replace($this->caracteres_malos, '', $query);
    $bitacora = "INSERT INTO bitacora (fecha, accion, descripcion, MySQL, recupera, idusuario, idcontrol) "
	    . "VALUES (NOW(), 2, 'Se retiran $cantidad existencias del producto $producto por caducidad.', '$queryBi', NULL, '".$_SESSION['idusuario']."', '".$_SESSION['idcontrol']."'); ";
    ejecutarConsulta($bitacora);    
    return ejecutarConsulta($query);
  }
  
  public function retiraProducto($idproducto,$cantidad) {
    echo $query = "UPDATE producto "
            . "SET existencia = existencia - $cantidad "
            . "WHERE idproducto = '$idproducto' "
            . "AND idcontrol = '".$_SESSION['idcontrol']."'; ";
    
    #Guardar accion en bitacora para llevar un registro.
    $queryBi = str_replace($this->caracteres_malos, '', $query);
    $bitacora = "INSERT INTO bitacora (fecha, accion, descripcion, MySQL, recupera, idusuario, idcontrol) "
	    . "VALUES (NOW(), 2, 'Inventario se actualiza a -$cantidad existencias del producto $producto por caducidad.', '$queryBi', NULL, '".$_SESSION['idusuario']."', '".$_SESSION['idcontrol']."'); ";
    ejecutarConsulta($bitacora);    
    return ejecutarConsulta($query);
  }
} ?>