<?php require_once '../config/global.php'; ?>
<?php require_once '../config/funcion.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta http-equiv="x-ua-compatible" content="ie=edge">

  <title>Punto de Venta <?=PRO_NOMBRE; ?> movil</title>
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="../public/plugins/fontawesome-free/css/all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../public/dist/css/adminlte.min.css">
  <!-- Toastr -->
  <link rel="stylesheet" href="../public/plugins/toastr/toastr.min.css">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="../public/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="icon" href="../imagenes/iconoPV.png" />
<?php if(is_numeric($_SESSION['idcontrol'])): ?>
  <meta http-equiv="refresh" content="9999;URL=salir.php" />
<?php else: ?>
  <meta http-equiv="refresh" content="0;URL=salir.php" />
<?php endif; ?>
</head>
<body class="hold-transition layout-top-nav layout-navbar-fixed layout-footer-fixed">
<div class="wrapper">

  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand-md navbar-light navbar-white">
    <div class="row">
      <div class="col-sm-12">
        <div class="input-group input-group-sm">
          <input name="buscaCodigo" id="buscaCodigo" class="form-control form-control-navbar col-sm-6" type="search" placeholder="Buscar Codigo de Producto" style="font-size: 20px; padding: 25px 20px; margin: 1em;">
          <input type="hidden" name="norepite" id="norepite">
        </div>
      </div>
      <div class="col-3">
        <a href="inicio.php"><i class="fas fa-reply fa-2x"></i></a>
      </div>
      <div class="col-  2">
        <a href="puntoVenta.php" title="Actualizar mi Punto de Venta"><i class="fas fa-cash-register fa-2x"></i></a>
      </div>
      <!-- Right navbar links -->
      <ul class="order-1 order-md-3 navbar-nav navbar-no-expand ml-auto">
        <!-- Messages Dropdown Menu -->
        <li class="nav-item dropdown" id="AvisoCaducidad">
          <!-- AvisoCaducidad -->
        </li>
        <!-- Notifications Dropdown Menu -->
        <li class="nav-item dropdown" id="AvisoExistencia">
          <!-- AvisoExistencia -->
        </li>
        <li class="nav-item">
          <a class="nav-link" data-widget="control-sidebar" data-slide="true" href="#">
            <i class="fas fa-star fa-2x"></i>
          </a>
        </li>
      </ul>
    </div>
  </nav>
  <!-- /.navbar -->

  <!-- Main content -->
  <div class="content-wrapper">
    
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-0"></div>
      </div><!-- /.container-fluid -->
    </section>
    
    <section class="content" >
      <div class="container-fluid" id="sectionBuscar">
        <div class="row">
          <div class="col-sm-12">
            <div class="card-header">
              <h5 class="card-title">Producto</h5>
            </div>
            <!-- Default box -->
            <div class="card collapsed-card" id="bcA">
              <div class="card-body">
                <h5>&nbsp;</h5>
                <div id="resultadoCodigo" class="row">
                  <!--puntoVenta.js/FbuscarCodigo-->
                </div>
                <!-- /.card-body -->
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
        </div>
      </div>
    </section>
    
    <section class="content">
      <!-- Default box -->
      <div class="card">
        <div class="card-header">
          <h4 class="card-title"><i class="fas fa-cash-register"></i> Productos para venta actual <label class="numerodeproductos"></label>.</h4>
          <div class="card-tools">
            <button type="button" class="btn btn-too" data-card-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fas fa-minus"></i>
            </button>
          </div>
        </div>
        <div class="card-body p-0">
          <div id="puntoVenta" class="row">
            <!--puntoVenta.js / listarPV-->
          </div>        
        </div>
        <!-- /.card-body -->
      </div>
      <!-- /.card -->

    </section>
    
  </div>
  <!-- /.content-wrapper -->

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-light">
    <!-- Control sidebar content goes here -->
    <div class="p-3" id="ProductoMasVendido">
      <!-- ProductoMasVendido.js --> 
    </div>
  </aside>
  <!-- /.control-sidebar -->
  
  <div class="modal fade" id="confirmaVenta">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h2 class="modal-title text-info">
            <i class="fas fa-hand-holding-usd"></i> Cobrar 
            <label class="NetoTotal"></label>-
          </h2>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="input-group input-group-sm">
            <input id="descuento" name="descuento" type="number" min="0" max="15" class="form-control text-center" placeholder="%">
            <span class="input-group-append">
              <button id="btnDescuento" type="button" class="btn btn-warning btn-flat">
                <i class="fas fa-percent"></i> Aplica Descuento
              </button>
            </span>
          </div>
          
          <div class="form-group clearfix">
            <br />
            <div class="icheck-primary d-inline">
              <input type="radio" id="radioPrimary1" name="pago" value="0" checked="">
              <label for="radioPrimary1">Pago en Efectivo</label>
            </div>
            <div class="icheck-primary d-inline">
              <input type="radio" id="radioPrimary2" name="pago" value="1">
              <label for="radioPrimary2">Pago Tarjeta</label>
            </div>            
            <div class="icheck-primary d-inline">
              <input type="radio" id="radioPrimary3" name="pago" value="2">
              <label for="radioPrimary3">Multipago</label>
            </div>
          </div>
          
          <div class="pago0">
            <label>Pago en Efectivo:</label><br />
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text">
                  <i class="fas fa-dollar-sign"></i>
                </span>
              </div>
              <input id="EfectivoModal" name="EfectivoModal" type="number" class="form-control text-center" placeholder="Monto en efectivo entregado">
              <div class="input-group-append">
                <div class="input-group-text"><i class="fas fa-hand-holding-usd"></i></div>
              </div>
            </div>          
            <h1 class="text-center text-success"><label id="vueltoModal">Cambio</label></h1>
          </div>
          
          <div class="pago1" style="display: none;">
            <div class="form-group clearfix">
              <label>Trarjeta de Debito</label><br />
              <div class="icheck-success d-inline">
                <input type="radio" id="radioTTDC1" name="ttdc" checked="" value="0">
                <label for="radioTTDC1" class="text-info"><i class="fab fa-cc-visa fa-3x"></i></label>
              </div>
              <div class="icheck-success d-inline">
                <input type="radio" id="radioTTDC2" name="ttdc" value="1">
                <label for="radioTTDC2" class="text-info"><i class="fab fa-cc-mastercard fa-3x"></i></i></label>
              </div>
              <div class="icheck-success d-inline">
                <input type="radio" id="radioTTDC3" name="ttdc" value="2">
                <label for="radioTTDC3" class="text-info"><i class="fab fa-cc-amex fa-3x"></i></label>
              </div>
              <p><label>Trarjeta de Credito</label></p>
              <div class="icheck-success d-inline">
                <input type="radio" id="radioTTDC4" name="ttdc" checked="" value="3">
                <label for="radioTTDC4" class="text-secondary"><i class="fab fa-cc-visa fa-3x"></i></label>
              </div>
              <div class="icheck-success d-inline">
                <input type="radio" id="radioTTDC5" name="ttdc" value="4">
                <label for="radioTTDC5" class="text-secondary"><i class="fab fa-cc-mastercard fa-3x"></i></i></label>
              </div>
              <div class="icheck-success d-inline">
                <input type="radio" id="radioTTDC6" name="ttdc" value="5">
                <label for="radioTTDC6" class="text-secondary"><i class="fab fa-cc-amex fa-3x"></i></label>
              </div>
            </div>
            <div class="row">
              <div class="col-sm-6">
                <label>Ultimos 4 digitos de Tarjeta:</label><br />
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text">
                      <i class="fas fa-credit-card"></i>
                    </span>
                  </div>
                  <input type="number" max="9999" class="form-control text-center" placeholder="Ultimos 4 digitos TD" id="tdc">
                </div>
              </div>
              <div class="col-sm-6">
                <label>Código Transacción de Pago:</label><br />
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text">
                      <i class="fas fa-university"></i>
                    </span>
                  </div>
                  <input type="text" maxlength="16" class="form-control text-center" placeholder="Codigo Acepcacion" id="codaceptacion">
                </div>
              </div>
            </div>
          </div>
          
          <div class="pago2" style="display: none;">
            <label>Multi Pago:</label><br />
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text">
                  <i class="fas fa-dollar-sign"></i>&nbsp;<i class="fas fa-hand-holding-usd"></i>&nbsp;<i class="fas fa-credit-card"></i>
                </span>
              </div>
              <textarea name="multipago" id="multipago" class="form-control" placeholder="Descripcion de las formas de pagos..."></textarea>
            </div>
            <label class="text-gray">Ejemplo de Abreviaciones para multipago:<br />
              E$<?= rand(100,999);?> igual a Efectivo,<br />
              TDD VISA <?= rand(1000,9999);?> $<?= rand(10,999);?> - igual a Tarjeta de Débito<br />
              TDC VISA <?= rand(1000,9999);?> $<?= rand(10,999);?> - igual a Tarjeta de Credito<br />
            </label>
          </div>
          
          <input type="hidden" id="TotalModal">
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">
            <i class="fas fa-times"></i> No Cobrar
          </button>
          <button type="button" class="btn btn-info" data-dismiss="modal" data-toggle="modal" data-target="#modalFinMail" id="btnFinPVmaildos">
            <i class="fas fa-envelope"></i> Mandar por E-Mail
          </button>
          <button type="button" class="btn btn-info" data-dismiss="modal" data-toggle="modal" data-target="#modalFinPrint" id="btnFinPVprint">
            <i class="fas fa-print"></i> Generar Ticket
          </button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->
  
  <div class="modal fade" id="modalFinPrint">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="btn btn-primary" data-dismiss="modal" id="btnPrint">
            <i class="fas fa-print"></i> Imprime Venta
          </button>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body text-center printableArea" id="divprintableArea">
          <!-- btnFinPVprint  click function -->
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->
  
  <div class="modal fade" id="modalPruebaPrint">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="btn btn-primary" data-dismiss="modal" id="btnPrintTest">
            <i class="fas fa-print"></i> Imprime prueba
          </button>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body text-center printableAreaTest" id="divPruebaPrint">
          <!-- PruebaImpresion click function resultado -->
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->
  
  <div class="modal fade" id="modalFinMail">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h2 class="modal-title text-info" id="mailTipopago"></h2>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body text-center">         
            <div class="input-group mb-3">
              <div class="input-group-prepend">
                <span class="input-group-text"><i class="fas fa-envelope"></i></span>
              </div>
              <input type="email" name="email" id="email" class="form-control" placeholder="E-mail">
            </div>
            <button type="submit" class="btn btn-success" id="btnFinPVmail">
              <i class="fas fa-paper-plane"></i> Mandar por correo
            </button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->

  <!-- Main Footer -->
  <footer class="footer">
    <div class="row">
      <div class="col-sm-6" align="center">
        <h2 class="text-success">
          <i class="fab fa-product-hunt" title="Cantidad de Productos"></i>
          #<label class="numerodeproductos"></label>
        </h2>
      </div>
      <div class="col-sm-6">
        <button type="button" class="btn btn-block btn-warning btn-lg" id="limpiarVenta">
          <i class="fas fa-broom"></i> Limpiar Venta
        </button>
      </div>
      <div class="col-sm-12">&nbsp;</div>
      <div class="col-sm-6" align="right">
        <h1 class="text-success text-center">
          Neto Total:<label class="NetoTotal"></label>
        </h1>
      </div>
      <div class="col-sm-6">
        <button type="button" class="btn btn-block btn-success btn-lg" data-toggle="modal" data-target="#confirmaVenta" id="CobrarVenta">
          <i class="fas fa-hand-holding-usd"></i> Cobrar Venta
        </button>
      </div>
      <div class="col-sm-12">&nbsp;</div>
    </div>
  </footer>
</div>
<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->

<!-- jQuery -->
<script src="../public/plugins/jquery/jquery.min.js"></script>
<!-- PrintArea jQuery Plugin -->
<script src="jquery.PrintArea.js"></script>
<!-- Bootstrap 4 -->
<script src="../public/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- Toastr -->
<script src="../public/plugins/toastr/toastr.min.js"></script>
<!-- AdminLTE App -->
<script src="../public/dist/js/adminlte.min.js"></script>
<script type="text/javascript" src="scriptsMovil/puntoVenta.js"></script>
</body>
</html>