var DataTable; //Variable para dataTable.
var toastr; //Varible de alertas
var ajaxFile = '../ajax/cajaChica.php'; //Variable para archivo de ajax.

//Funcion que se ejecuta al inicio
function iniciar(){
  corteCaja();
  listarRegistros();
}

function listarRegistros(){
  var jqxhr = $.post(ajaxFile+ "?op=listarMovil", function (r){
    //console.log(r);
  })
  .done(function(r) {
    $('#TBodyData').html(r);
  })
  .fail(function(r) {
    console.log(r);
    toastr.error('jQuery Listar Caja Chica . . .');
  });
}

$('#btnCajaChica').click(function(){
  var monto = $('#monto').val();
  var accion = $("input[type='radio'][name='accion']:checked").val();
  var descripcion = $('#descripcion').val();
  
  if(monto >= 0){
  
  //console.log(monto,accion,descripcion);
  var jqxhr = $.post(ajaxFile+ "?op=agregarCajaChica", {monto:monto, accion:accion, descripcion:descripcion}, function (r){
    //console.log(r);
  })
  .done(function(r) {
    if(accion === '0'){
      monto = '-'+monto;
      toastr.success('Monto $'+monto+' registrado.');
    }else{
      toastr.warning('El Monto de caja chica se ajusto en $'+monto);
    }
    
    $('#monto').val(null);
    $('#accion').val(null);
    $('#descripcion').val(null);
    $("#gasto").attr('checked',true);    
    corteCaja();
    DataTable.ajax.reload();
  })
  .fail(function(r) {
    console.log(r);
    toastr.error('jQuery Agregar Caja Chica . . .');
  });
  }else{
    toastr.warning('Indique un monto para registrar');
  }
    
});

function corteCaja(){
  var jqxhr = $.post(ajaxFile+ "?op=corteCaja", function (resultado){
    //console.log(resultado);
  })
  .done(function(resultado) {
    $('#corteCaja').html(resultado);
  })
  .fail(function(resultado) {
    console.log(resultado);
    toastr.error('jQuery Corte de Caja . . .');
  });
}

$('input:radio[name=accion]').change(function(){
  var accion = $('input:radio[name=accion]:checked').val();
  
  if(accion === '0'){
    $('#btnCajaChica').removeClass('btn-warning')
            .removeClass('btn-primary')
            .addClass('btn-danger');
    $('#btnCajaChica').html('<i class="fas fa-hand-holding-usd"></i> Registrar Gasto');
    $('#labelAccion').html('Descripcion del gasto:');
  }
  
  if(accion === '1'){
    $('#btnCajaChica').removeClass('btn-danger')
            .removeClass('btn-primary')
            .addClass('btn-warning');
    $('#btnCajaChica').html('<i class="fas fa-donate"></i> Ajustar Monto de Caja');
    $('#labelAccion').html('Descripcion del ajuste de caja:');
  }
  
  if(accion === '2'){
    $('#btnCajaChica').removeClass('btn-danger')
            .removeClass('btn-warning')
            .addClass('btn-primary');
    $('#btnCajaChica').html('<i class="fas fa-hand-holding-usd"></i> Corte de Caja');
    $('#labelAccion').html('Notas para el corte de caja:');
  }
  
});

iniciar(); //Ejecuta iniciar, para que simpre se ejecute.