var DataTable; //Variable para dataTable.
var Swal,toastr; //Varible de alertas
var ajaxFile = '../ajax/producto.php'; //Variable para archivo de ajax.
var camposForm = ['idproducto','codigobarras','codigosat','codigoproveedor','marca','producto','cantidad','unimedida','descripcion','uso','existenciaminima','compra','ganancia','subtotal','iva','total'];

function iniciar(){
  $('#formularioX').on('submit',function(e){ //si se activa el evento submit llamma funcion ...
    guardaryeditar(e);
  });
  limpiar();
  listarRegistros();
}

function limpiar(){
  //Se usa Jquery $("#NombreDelObjeto).val("Valor a mandar");
  for(var i=0; i<camposForm.length; i++){
    $("#"+camposForm[i]).val(null);
    $("#"+camposForm[i]).prop('disabled',false);
    //$("#"+camposForm[i]).selectpicker('refresh');
  } 
  
  $('#existencia').val(null);
  $('#existenciaminima').val(null);
  
  $('#divFormularioProducto').slideToggle('slow');
  
  $('#resultado').html('');
  $('#filename').html('Seleccione un archivo csv . . .');
  
  $('#encabezados').prop('checked', false);
  
  $('#actualizacion').html('<i class="fab fa-product-hunt"></i> Agregar producto ');
  $("input[type='radio'][name='civa'][value='1']").prop("checked", true);
  
  $('#btnEditar').remove();
  $('#btnClonar').remove();
  $('#btnBorrar').remove();
  $('#btnGuardar').fadeIn(2000);
}

function guardaryeditar(e){
  e.preventDefault(); //Para que no se active la accion predeterminad del evento
  //$("#btnGuardar").prop("disabled",true);
  var formDatos = new FormData($('#formularioX')[0]); //Para obtener los datos del id=formularioX
  $.ajax({ //Metodo ajax
    url: ajaxFile+ "?op=guardaryeditar", //archivo donde lo envia
    type: "POST",
    data: formDatos, //La varible var formData = new FormData mas arriba
    contentType: false,
    processData: false,
        
    success: function(respuesta){
      //console.log(respuesta);
      var separar = respuesta.split(','); //Separa en arreglo Var1,Var2,etc..
      if(separar[0] === 'success'){ 
        toastr.success(separar[1]);
        limpiar();
      }
      if(separar[0] === 'warning'){ toastr.success(separar[1]); }
      if(separar[0] === 'error'){ 
        console.log(respuesta);
        toastr.error(separar[1]);
      }      
      DataTable.ajax.reload();
    }
  });
}

function listarRegistros(){
  DataTable = $('#DataTable').dataTable({
    "aProcessing": true, //Activa el prosedamietno del datatables
    "aServerSide": true, //Paginacion y filtrado realizados por el servidor
    dom: 'Bfrtip', //Definimos los elementos del control de tabla
    buttons:['copyHtml5','excelHtml5','csvHtml5','pdf'],
    "ajax":{
      url: ajaxFile+ '?op=listarRegistros&movil=81', //Obtener los valores desde url
      type: "get",
      dataType: "json", //Datos codificados mediante json
      error:function(e){ //en caso de errores
        console.log(e.responseText);
      }
    },
    "createdRow": function( row, data, dataIndex ) { //Establecer color a las filas
      //condiciones
      if(data[2] <=0 ){
        $(row).css('background-color','rgba(108, 117, 125, .5)'); //Gris
      }
      
      if(data[2] > 0){
        var r = (10-data[2])/10;
        $(row).css('background-color','rgba(255, 193, 7, '+r+')'); //amarillo
      }
      
      if(data[2] > 10){
        $(row).css('background-color','rgba(40, 167, 69, .1)'); //verde
      }
    },
    "responsive": true,
    "bBestroy": true,
    "destroy": true,
    "iDisplayLength": 10, //Paginacion de X en X registros.
    "order": [[2, "desc"]] //Ordenar (columna,orden).
  }).DataTable();
}

//Validar la existencia de un codigo similar....

function validaCodigo(){
  var clave = $("#codigobarras").val();
  //Si clave es mayor que # y exite un provvedor seleccionado
  if(clave.length > 2){
    var jqxhr = $.get(ajaxFile+ '?op=validaCodigo',{ clave:clave }, function (data){
      //console.log(r);
    })
    .done(function(data) {
      var separar = data.split('#'); //Separa en arreglo Var1,Var2,etc..
      $('#resultado').html(separar[1]);
      
      if(separar[0]>0){        
        toastr.info('Se encontraron ' +separar[0]+ ' codigo(s) de producto existente, verifique en los resultados.');
        $('#btnGuardar').prop('disabled',true);
      }
      
      if(separar[0]==='0'){
        toastr.info('Sin resultados para el codigo ' +clave);
        $('#resultado').html('Sin resultados para el codigo ' +clave);
        $('#btnGuardar').prop('disabled',false);
      }
      
    })
    .fail(function() {
      toastr.error('jQuery validaCodigo . . .');
    });
  }    
}
//});

function listarMarca(){
  var buscar = $('#marca').val();
  if(buscar.length > 0){
    buscar = buscar.replace(/[`~!@#\'"{\}\[\]\\\/]/gi,'');
    $('#marca').val(buscar);
    $.post(ajaxFile+ '?op=listarMarca',{buscar:buscar}, function(r){
      $("#listarmarca").html(r);
    });
  }
}

function listarProducto(){
  var buscar = $('#producto').val();
  if(buscar.length > 0){
    buscar = buscar.replace(/[`~!@#\'"{\}\[\]\\\/]/gi,'');
    $('#producto').val(buscar);
    $.post(ajaxFile+ '?op=listarProducto',{buscar:buscar}, function(r){
      $("#listarproducto").html(r);
    });
  }
}

function listarMedida(){
  var buscar = $('#unimedida').val();
  if(buscar.length > 0){
    buscar = buscar.replace(/[`~!@#\'"{\}\[\]\\\/]/gi,'');
    $('#unimedida').val(buscar);
    $.post(ajaxFile+ '?op=listarMedida',{buscar:buscar}, function(r){
      $("#listarmedida").html(r);
    });
  }
}

function mostrarRegistro(idRegistro,ActDes){ //Mostrar registro para visualizacion unicamnete
  limpiar();
  $('#divFormularioProducto').slideDown('slow'); //Entrada
  //console.log(idRegistro);
  
  var jqxhr = $.post(ajaxFile+ '?op=mostrarRegistro', { idRegistro:idRegistro }, function (data){
    //console.log(data);
  })
  .done(function(data) {
    data = JSON.parse(data);
    
    var recupera = null;
    $('#codigobarras').val(data.idproducto);
    recupera = recupera + 'codigobarras(' + data.idproducto+') ';
    $('#codigosat').val(data.codigosat);
    recupera = recupera + 'codigosat(' + data.codigosat+') ';
    $('#codigoproveedor').val(data.codigoproveedor);
    recupera = recupera + 'codigoproveedor(' + data.codigoproveedor+') ';
    $('#marca').val(data.marca);
    recupera = recupera + 'marca(' + data.marca+') ';
    $('#producto').val(data.producto);
    recupera = recupera + 'producto(' + data.producto+') ';
    $('#cantidad').val(data.cantidad);
    recupera = recupera + 'cantidad(' + data.cantidad+') ';
    $('#unimedida').val(data.unidadmedida);
    recupera = recupera + 'unimedida(' + data.unidadmedida+') ';
    $('#descripcion').val(data.descripcion);
    recupera = recupera + 'descripcion(' + data.descripcion+') ';
    $('#uso').val(data.uso);
    recupera = recupera + 'uso(' + data.uso+') ';
    $('#existencia').val(data.existencia);
    recupera = recupera + 'existencia(' + data.existencia+') ';
    $('#existenciaminima').val(data.existenciaminima);
    recupera = recupera + 'existenciaminima(' + data.existenciaminima+') ';
    $('#compra').val(data.compra);
    recupera = recupera + 'compra(' + data.compra+') ';
    $('#ganancia').val(data.ganancia);
    recupera = recupera + 'ganancia(' + data.ganancia+') ';
    $('#subtotal').val(data.subtotal);
    recupera = recupera + 'subtotal(' + data.subtotal+') ';
    if(data.iva > 0){
      $("input[type='radio'][name='civa'][value='1']").prop("checked", true);
    }else{
      $("input[type='radio'][name='civa'][value='0']").prop("checked", true);
    }
    $('#iva').val(data.iva);
    recupera = recupera + 'iva(' + data.iva+') ';    
    $('#total').val(data.total);
    recupera = recupera + 'total(' + data.total+') ';
    
    $('#idproducto').val(data.idproducto);
    $('#actualizacion').html('<i class="fab fa-product-hunt"></i> Actualizar producto ' +data.idproducto);
    
    $('#recupera').val(recupera);
    
    if(ActDes){
      var i;
      for(i=0; i<camposForm.length; i++){
        $("#"+camposForm[i]).prop('disabled',ActDes);
      }
      $('#btnExtra').append('<button type="button" id="btnEditar" class="btn btn-block btn-outline-warning" onclick="mostrarRegistro(' +data.idproducto+ ', false);"><i class="fas fa-edit"></i> Editar producto</button>');
      $('#verClonar').append('<button type="button" id="btnClonar" class="btn btn-block btn-outline-info" onclick="clonar();"><i class="fas fa-clone"></i> Clonar producto</button>');
      $('#btnGuardar').fadeOut(900);
      toastr.info('Registro '+idRegistro+' cargado...');  
    }else{
      toastr.info('Registro '+idRegistro+' cargado listo para editar...');  
      $('#verClonar').append('<button id="btnBorrar" onclick="Borrar();" type="button" class="btn btn-block btn-danger"><i class="far fa-trash-alt"></i> Eliminar Producto</button>');
    }
  })
  .fail(function(data) {
    console.log(data);
    toastr.error('jQuery mostrarRegistro . . .');
  });
}

function mostrarForm(variable){
  limpiar();
  $( '#'+variable ).slideDown('slow'); //Entrada
}

function clonar(){
  
  $('#actualizacion').html('<i class="far fa-clone"></i> Producto Clonado...');    
  $('#existencia').val(null);
  $('#existenciaminima').val(null);
  $('#ganancia').val(null);
  $('#subtotal').val(null);
  $('#iva').val(null);
  $('#total').val(null);
  $('#idproducto').val(null);
  
  var i;
  for(i=0; i<camposForm.length; i++){
    $("#"+camposForm[i]).prop('disabled',false);
  }
  $('#btnClonar').fadeOut(2000);
  $('#btnEditar').fadeOut(2000);
  $('#btnGuardar').fadeIn(2000);
  
  $('#codigobarras').val(null).focus();
  toastr.info('Se clono el producto rellene los campos faltantes...');
}

function restringeCaracter(campoForm){
  var notas = null;
  notas = $('#'+campoForm).val();
  notas = notas.replace(/[&\/\\#$~'"<>{}]/g, '');
  $('#'+campoForm).val(notas);
}

function calcular(caja) {
  var IVA;
  var compra = $('#compra').val();
  var ganancia = 1+($('#ganancia').val()/100);
  var subtotal = $('#subtotal').val();
  var iva = $('#iva').val();
  var total = $('#total').val();
  
  if($("input[type='radio'][name='civa']:checked").val() === '1') IVA = 0.16;
  else IVA = 0;  
  
  if(caja === 'ganancia'){
    $('#subtotal').val( (compra * ganancia).toFixed(2) );
    $('#iva').val( ((compra * ganancia)*IVA).toFixed(2) );
    $('#total').val( ((compra * ganancia)*(IVA+1)).toFixed(2) );    
  }
  if(caja === 'subtotal'){
    $('#ganancia').val( (((subtotal/compra)-1)*100).toFixed(2) ); //Regresar el % de ganancias segun subtotal
    $('#iva').val( ((subtotal)*IVA).toFixed(2) );
    $('#total').val( ((subtotal)*(IVA+1)).toFixed(2) );
  }
  if(caja === 'iva'){
    $('#total').val( (parseFloat(subtotal)+parseFloat(iva)).toFixed(2) );
  }  
  if(caja === 'total'){
    $('#subtotal').val( (total/parseFloat(1+IVA)).toFixed(2) );
    subtotal = $('#subtotal').val();
    $('#iva').val( ((subtotal)*IVA).toFixed(2) );
    total = total / (1+IVA);
    $('#ganancia').val( (((total/compra)-1)*100).toFixed(2) ); //Regresar el % de ganancias segun total
  }
  toastr.info('Recalculando desde '+caja+'...');  
}

function Borrar(){
  Swal.fire({
    title: '¿Esta, seguro de Borrarlo?',
    text: "¡No podras revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Si, borrarlo!'
  }).then((result) => {
    if (result.isConfirmed) {
      var idControl = $('#idproducto').val();
      $.get(ajaxFile+ '?op=BorrarRegistro', {idControl:idControl}, function(data, status){
        toastr.error('Su registro fue borrado...');
      });
      Swal.fire(
        'Borrado!',
        'Su registro fue borrado.',
        'success'
      );
    listarRegistros();
  }
  });
}

iniciar();