var DataTable; //Variable para dataTable.
var Swal, toastr; //Varible de alertas
var ajaxFile = '../ajax/resurtir.php'; //Variable para archivo de ajax.
var camposForm = [
        ['rfc','nombreproveedor','direccionproveedor','facturaproveedor','codigobarras','cantidadproducto','caducidad','descripcion','existenciaminima','compra','ganancia','subtotal','iva','total','existerfc'],
        ['codigobarras','cantidadproducto','caducidad','existenciaminima','descripcion','existenciaminima','compra','ganancia','subtotal','iva','total']
    ];
//var camposForm = ['rfc','nombreproveedor','direccionproveedor','facturaproveedor','codigobarras','cantidadproducto','caducidad','descripcion','compra','ganancia','subtotal','iva','total','existerfc'];
//var camposForm2 = ['codigobarras','cantidadproducto','caducidad','descripcion','compra','ganancia','subtotal','iva','total','existerfc'];
//Funcion que se ejecuta al inicio
function iniciar(){
  //Initialize Select2 Elements
  buscarElementoSelect2();
    
  $('#formularioX').on('submit',function(e){ //si se activa el evento submit llamma funcion ...
    guardaryeditar(e);
  });  
  limpiar();
  listaEventos();
}

function limpiar(){
  //Se usa Gquery $("#NombreDelObjeto).val("Valor a mandar");
  for(var i=0; i<camposForm[0].length; i++){
    $("#"+camposForm[0][i]).val(null);
  }
  //$('#divBuscar').slideToggle( "slow" ); //Salida  
  //$('#divFormulario').slideToggle( "slow" ); //Salida
  $('#divBuscar').hide( "slow" ); //Salida  
  $('#divFormulario').hide( "slow" ); //Salida
}

function mostrarDiv(div, limpia = 0){
  if(limpia){ limpiar(); }
  $( '#'+div ).slideDown('slow'); //Entrada
}

function guardaryeditar(e){
  e.preventDefault(); //Para que no se active la accion predeterminad del evento
  
  //$("#btnGuardar").prop("disabled",true);
  var formDatos = new FormData($("#formularioX")[0]); //Para obtener los datos del id=formularioX
  $.ajax({ //Metodo ajax
    url: ajaxFile+ '?op=guardaryeditar', //archivo donde lo envia
    type: "POST",
    data: formDatos, //La varible var formData = new FormData mas arriba
    contentType: false,
    processData: false,
        
    success: function(respuesta){
      //console.log(respuesta); // Ver consulta
      
      var separar = respuesta.split(','); //Separa en arreglo Var1,Var2,etc..
      if(separar[0] === 'success'){ 
        toastr.success(separar[1]);
        for(var i=0; i<camposForm[1].length; i++){
          $("#"+camposForm[1][i]).val(null);
        }
      }
      if(separar[0] === 'warning'){ toastr.success(separar[1]); }
      if(separar[0] === 'error'){ 
        //console.log(respuesta);
        toastr.error(separar[1]);
      }      
      //DataTable.ajax.reload();
    }
  });
  listaEventos();
}

$('#btnBuscarContribuyente').click(function(){
  $('#modalBuscaContribuyente').modal('show');
  $('#buscaContribuyente').val(null);
  $('#listaContribuyente').html(null);
  setTimeout(function (){ 
    $('#buscaContribuyente').focus();
  },999);
});

$('#rfc').keyup(function(){
  listaContribuyente();
});
$('#rfc').change(function(){
  listaContribuyente();
});

function listaContribuyente(){
  var buscando = $('#rfc').val();
  var jqxhr = $.post(ajaxFile+ '?op=buscaContribuyente',{buscando:buscando,movil:1}, function(data, status){
    //console.log(data);
  })
  .done(function(data) {
    //console.log(data);
    $('#listaContribuyente').html(data);
    //$('.listaEventos').cl
  })
  .fail(function(data) {
    //console.log(data);
    toastr.error('jQuery busca contribuyente . . .');
  });
}

function validaRFC(){
  var rfc = $('#rfc').val();
  $('#existerfc').val(null);

  if(rfc.length > 1){
    $.post(ajaxFile+ '?op=validaRFC', { rfc:rfc }, function(respuesta, status){
      
      //console.log(respuesta);
      var separar = respuesta.split('#'); //Separa en arreglo Var1,Var2,etc..
      if(separar[0] === '1'){
        $('#existerfc').val(separar[1]);
        $('#rfc').val(separar[1]);
        $('#nombreproveedor').val(separar[2]);
        $('#direccionproveedor').val(separar[3]);
      }if(separar[0] === '2'){
        $("#listarfc").html(separar[1]);
        $('#existerfc').val(null);
        $('#nombreproveedor').val(null);
        $('#direccionproveedor').val(null);
      }      
    });
  }
}

function seleccionaContribuyente(seleccion){  
  $('#modalBuscaContribuyente').modal('hide');
  $('#rfc').val(seleccion);  
  setTimeout(function (){ 
      validaRFC();
      $('#rfc').focus();
      $('#listaContribuyente').html(null);
  }, 999);
}

//Validar la existencia de un codigo similar....
function validaCodigo(){
//$('#codigobarras').change(function() {
  var clave = $("#codigobarras").val();
    
  //Si clave es mayor que # y exite un provvedor seleccionado
  if(clave.length > 0){
    //Mandar los datos ajax por GET $.get o POST $.post
    var jqxhr = $.get(ajaxFile+ '?op=validaCodigo', { clave:clave }, function(data, status){
      //console.log('f',data);
    })
    .done(function(data) {
      var separar = data.split('#R'); //Separa en arreglo Var1,Var2,etc..
      $('#descripcion').val(separar[0]);
      $('#compra').val(separar[1]);
      $('#ganancia').val(separar[2]);
      $('#subtotal').val(separar[3]);
      $('#iva').val(separar[4]);
      $('#total').val(separar[5]);
      $('#existencia').val(separar[6]);
      $('#existenciaminima').val(separar[7]);
      
      if(separar[4] > 0){
        $("input[type='radio'][name='civa'][value='1']").prop("checked", true);
      }else{
        $("input[type='radio'][name='civa'][value='0']").prop("checked", true);
      }
      
      setTimeout(function(){
        if(data !== ''){        
          toastr.info('Se encontraron codigo ' +clave+ ' de producto existente, verifique el producto.');
        }else{
          toastr.warning('No se encontraron codigo ' +clave+ ' verifique el producto.');
        }
        }, 2000);
    })
    .fail(function(data) {
      toastr.error('jQuery Listar Pago . . .');
      console.log(data);
    });
  }
}

function listaEventos(){
  //$('#divEventos').fadeIn(2000);
  $('.listaEventos').remove(); //Borrar etiquetas extras 
  
  $.get(ajaxFile+ '?op=listaEventos', function(data, status){
    //console.log(data);
    $('#listaEventos').append(data); //Agrega html a id
  });
}

$('#btnCancelar').click(function(){
  limpiar();
});

function calcular(caja) {
  var IVA;
  var compra = $('#compra').val();
  var ganancia = 1+($('#ganancia').val()/100);
  var subtotal = $('#subtotal').val();
  var iva = $('#iva').val();
  var total = $('#total').val();
  
  if($("input[type='radio'][name='civa']:checked").val() === '1') IVA = 0.16;
  else IVA = 0;  
  
  if(caja === 'ganancia'){
    $('#subtotal').val( (compra * ganancia).toFixed(2) );
    $('#iva').val( ((compra * ganancia)*IVA).toFixed(2) );
    $('#total').val( ((compra * ganancia)*(IVA+1)).toFixed(2) );    
  }
  if(caja === 'subtotal'){
    $('#ganancia').val( (((subtotal/compra)-1)*100).toFixed(2) ); //Regresar el % de ganancias segun subtotal
    $('#iva').val( ((subtotal)*IVA).toFixed(2) );
    $('#total').val( ((subtotal)*(IVA+1)).toFixed(2) );
  }
  if(caja === 'iva'){
    $('#total').val( (parseFloat(subtotal)+parseFloat(iva)).toFixed(2) );
  }  
  if(caja === 'total'){
    $('#subtotal').val( (total/parseFloat(1+IVA)).toFixed(2) );
    subtotal = $('#subtotal').val();
    $('#iva').val( ((subtotal)*IVA).toFixed(2) );
    total = total / (1+IVA);
    $('#ganancia').val( (((total/compra)-1)*100).toFixed(2) ); //Regresar el % de ganancias segun total
  }
  toastr.info('Recalculando desde '+caja+'...');  
}

$('#btnBuscar').click(function(){
  listarRegistros();
});

function listarRegistros(){
  var c = $('#buscar').val();
  
  DataTable = $('#DataTable').dataTable({
    "aProcessing": true, //Activa el procedimietno del DataTables
    "aServerSide": true, //Paginación y filtrado realizados por el servidor
    dom: 'Bfrtip', //Definimos los elementos del control de tabla
    buttons:['copyHtml5','excelHtml5','csvHtml5','pdf'],
    "ajax":{
      url: ajaxFile+ '?op=Buscar&c='+c, //Obtener los valores desde url
      type: "POST",
      dataType: "json", //Datos codificados mediante json
      error:function(e){ //en caso de errores
        console.log(e.responseText);
      }
    },
    "createdRow": function( row, data, dataIndex ) { //Establecer color a las filas
      //condiciones
      if(data[6] === '0'){
        $(row).css('background-color','rgba(108, 117, 125, .5)'); //Gris
      }
      
      if(data[6] === '1'){
        $(row).css('background-color','rgba(255, 193, 7, .6)'); //amarillo
      }
      if(data[6] === '2'){
        $(row).css('background-color','rgba(255, 193, 7, .3)'); //Amarillo
      }
      if(data[6] === '3'){
        $(row).css('background-color','rgba(255, 193, 7, .1)'); //amarillo
      }
      
      if(data[4] === data[6]){
        $(row).css('background-color','rgba(40, 167, 69, .1)'); //verde
      }
    },
    "bBestroy": true,
    "destroy": true,
    "iDisplayLength": 10, //Paginacion de X en X registros.
    "order": [[0, "desc"]] //Ordenar (columna,orden).
  }).DataTable();
}

function buscarElementoSelect2(){
  // https://obedalvarado.pw/blog/autocomplete-select2-usando-jquery-ajax-php-y-mysql/
  // https://select2.org/data-sources/ajax
  $('#BuscaProducto').select2({
    minimumInputLength: 1,
    placeholder: 'Busqueda de producto...',
    ajax: {
      url: function (params) {
        return ajaxFile+ '?op=Select2&term='+params.term;
      },
      type: "POST",
      dataType: 'json',
      delay: 250,
      processResults: function (data) {
        return {          
          results: data
        };
      },
      error:function(data){ //en caso de errores
        console.log(data.responseText);
      }
      //cache: true
    }
  }).on('select2:select', function (e) {
    var data = e.params.data;
    $("#codigobarras").val(data.id);
    //console.log(data.id);
    validaCodigo();
  });
}

function mostrarEditaResurtir(idresurtir, idproducto, cantidad, caducidad){
  $('#modalEditaResurtir').modal('show');
  $('#idresurtir').val(idresurtir);
  $('#idproducto').val(idproducto);
  $('#cantidadproductoedita').val(cantidad);
  $('#cantidadproductoantes').val(cantidad);
  $('#caducidadedita').val(caducidad);
};

$('#btnEditarResurtir').click(function (){
  var idresurtir = $('#idresurtir').val();
  var idproducto = $('#idproducto').val();
  var cantidadproductoedita = $('#cantidadproductoedita').val();
  var cantidadproductoantes = $('#cantidadproductoantes').val();
  var caducidadedita = $('#caducidadedita').val();
  
  var jqxhr = $.post(+ajaxFile+ '?op=EditarResurtir', {
    idresurtir:idresurtir,
    idproducto:idproducto,
    cantidadproductoedita:cantidadproductoedita,
    cantidadproductoantes:cantidadproductoantes,
    caducidadedita:caducidadedita }, function(data, status){
    //console.log(data);
    toastr.success('Resurtido Actualizado...');
    $('#modalEditaResurtir').modal('hide');
  })
  .done(function(data) {
    listaEventos();
    toastr.success(data);
  })
  .fail(function(data) {
    //console.log(data);
    toastr.error('jQuery Editar Resurtir . . .');
  });
});

iniciar(); //Ejecuta iniciar, para que simpre se ejecute.