<?PHP require 'header.php'; ?>

<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    
    <section id="inicioPaguina" class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-4">
            <h1><i class="fab fa-product-hunt"></i> Productos</h1>
          </div>
          <div class="col-sm-8 text-right">
            <b>Iconos y Accion</b>
            <i class="fas fa-plus"></i> Agregar
            <i class="fas fa-save"></i> Salvar
            <i class="fas fa-eye"></i> Mostrar 
            <i class="fas fa-edit"></i> Editar
            <i class="fas fa-ban"></i> Cancelar
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item active">Opciones</li>
              <li class="breadcrumb-item"><a href="#" onclick="mostrarForm('divFormularioProducto');"><i class="fas fa-plus"></i> Agregar un Producto</a></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-12">
	  <!-- Contenido abajo -->
        
      <!-- Formulario un dato -->
      <form name="formularioX" id="formularioX" method="POST">
        
        <div class="card" id="divFormularioProducto">
          <div class="card-header">
            <div class="card-header">
              <h4 class="card-title" id="actualizacion"><i class="fab fa-product-hunt"></i> Agregar un Producto</h4>
            </div>
            <div class="row">              
              <div class="col-sm-4 form-group">
                <label class="control-label">Codigo de Barras:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-barcode"></i></span>
                  </div>
                  <input name="codigobarras" id="codigobarras" type="text" class="form-control" placeholder="Codigo Barras del Producto" autocomplete="off" required="" onkeyup="validaCodigo();">
                </div>
              </div>
              
              <div class="col-sm-4 form-group">
                <label class="control-label">Codigo del SAT</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-donate"></i></span>
                  </div>
                  <input name="codigosat" id="codigosat" type="text" class="form-control" placeholder="Codigo Producto SAT">
                </div>
              </div>
              
              <div class="col-sm-4 form-group">
                <label class="control-label">Codigo Interno del Proveedor:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-dolly"></i></span>
                  </div>
                  <input name="codigoproveedor" id="codigoproveedor" type="text" class="form-control" placeholder="Codigo del Proveedor">
                </div>
              </div>
              
              <div class="col-sm-12 form-group">
                <ul id="resultado">
                  <!--.js validaCodigo -->
                </ul>
              </div>
              
              <div class="col-sm-3 form-group">
                <label class="control-label">Marca:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-tags"></i></span>
                  </div>
                  <input name="marca" id="marca" list="listarmarca" type="text" class="form-control" placeholder="Marca: Apple,Nestle,Sony,Nissan..." autocomplete="off" onkeyup="listarMarca();">
                  <datalist id="listarmarca">
                    <!-- producto.js / listar -->
                  </datalist>
                </div>
              </div>
              
              <div class="col-sm-4 form-group">
                <label class="control-label">Tipo de Producto:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fab fa-product-hunt"></i></span>
                  </div>
                  <input name="producto" id="producto" list="listarproducto"type="text" class="form-control" placeholder="Producto: Jabón,Perfumes,Maquillaje,Crema..." autocomplete="off" onkeyup="listarProducto();">
                  <datalist id="listarproducto">
                    <!-- producto.js / listarProducto -->
                  </datalist>
                </div>
              </div>
              
              <div class="col-sm-2 form-group" title="Medida para el producto ejemplo 30 g solo numero.">
                <label class="control-label">Cantidad de #:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-boxes"></i></span>
                  </div>
                  <input name="cantidad" id="cantidad" type="number" class="form-control" placeholder="#Numero..." autocomplete="off">
                </div>
              </div>
              
              <div class="col-sm-3 form-group">
                <label class="control-label">Unidade de Medida:</label>
                <label class="control-label"></label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-balance-scale"></i></span>
                  </div>
                  <input name="unimedida" id="unimedida" list="listarmedida" type="text" class="form-control" placeholder="Pieza,Litros,Gramos..." autocomplete="off" onkeyup="listarMedida();">
                  <datalist id="listarmedida">
                    <!-- producto.js / listarMedida -->
                  </datalist>
                </div>
              </div>
              
              <div class="col-sm-12 form-group">
                <label class="control-label">Descripcion detallada del producto:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-bookmark"></i></span>
                  </div>
                  <textarea name="descripcion" id="descripcion" class="form-control" rows="2" placeholder="Descripcion detalles e informaccion del producto . . ." required=""></textarea>
                </div>
              </div>
              
              <div class="col-sm-12 form-group">
                <label class="control-label">Descripcion del uso para el producto:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-bookmark"></i></span>
                  </div>
                  <textarea name="uso" id="uso" class="form-control" rows="2" placeholder="Descripcion de uso para el producto . . ."></textarea>
                </div>
              </div>
              
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="control-label">Existencias de productos:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-boxes"></i></span>
                    </div>
                    <input name="existencia" id="existencia" type="number" min="0" class="form-control" placeholder="Existencias..." disabled="true">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="control-label">Existencias minimas:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-box"></i></span>
                    </div>
                    <input name="existenciaminima" id="existenciaminima" type="number" min="0" class="form-control" placeholder="Existencia minima.">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-5"><!-- Separacion --></div>
              
              <div class="col-sm-2">
                <div class="form-group">
                  <label class="control-label">Precio de Compra:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-hand-holding-usd"></i></span>
                    </div>
                    <input name="compra" id="compra" type="number" step="0.01" min="0.01" class="form-control" placeholder="Pre. Compra" required="">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-2">
                <div class="form-group">
                  <label class="control-label">IVA CERO ?:</label>
                  <div class="input-group mb-2">
                    <div class="icheck-success d-inline">
                      <input type="radio" id="ivacero" name="civa" checked="" value="1">
                      <label for="ivacero">Calcula IVA </label>  
                    </div>
                    <div class="icheck-gray d-inline">
                      <input type="radio" id="caliva" name="civa" value="0">
                      <label for="caliva">Sin IVA </label>  
                    </div>
                  </div>
                </div>
              </div>
              
              <div class="col-sm-2">
                <div class="form-group">
                  <label class="control-label">% Ganancia sobre compra:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-percent"></i></span>
                    </div>
                    <input name="ganancia" id="ganancia" type="number" step="0.01" min="0.01" class="form-control" placeholder="% Ganancia" required="" onkeyup="calcular('ganancia');">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-2">
                <div class="form-group">
                  <label class="control-label">SubTotal:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-dollar-sign"></i></span>
                    </div>
                    <input name="subtotal" id="subtotal" type="number" step="0.01" class="form-control" placeholder="SubTotal" required="" onkeyup="calcular('subtotal');">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-2">
                <div class="form-group">
                  <label class="control-label">IVA:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-dollar-sign"></i></span>
                    </div>
                    <input name="iva" id="iva" type="number" step="0.01" class="form-control" placeholder="I.V.A." required="" onkeyup="calcular('iva');">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-2">
                <div class="form-group">
                  <label class="control-label">Total:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-dollar-sign"></i></span>
                    </div>
                    <input name="total" id="total" type="number" step="0.01" class="form-control" placeholder="Total" required="" onkeyup="calcular('total');">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-3" id="verClonar"><!-- Separacion --></div>
              <div class="col-sm-3" id="btnExtra"><!-- producto.js --></div>
              <div class="col-sm-3">
                <div class="input-group mb-2">
                  <button type="submit" id="btnGuardar" class="btn btn-block btn-outline-success"><i class="fas fa-save"></i> Guardar producto</button>
                  <input id="idproducto" name="idproducto" type="hidden">
                  <input id="recupera" name="recupera" type="hidden">
                </div>
              </div>               
              <div class="col-sm-3">
                <div class="input-group mb-2">
                  <button type="button" class="btn btn-block btn-outline-secondary" onclick="limpiar(); window.location.href = '#inicioPaguina';">
                    <i class="fas fa-ban"></i> Cancelar</button>
                </div>
              </div>
              
            </div>            
          </div>
        </div>
      </form>
      <!-- /Formulario un dato -->

<!-- DataTable -->
          <div class="card">
            <div class="card-header">
              <h3 class="card-title"><i class="fab fa-product-hunt"></i> Productos</h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              
<!--              <table id="DataTable" class="table table-bordered table-striped">-->
              <table class="table table-bordered" id="DataTable">
              <thead>
                <tr>
                  <th>Codigo</th>
                  <th>SAT</th>
                  <th>Marca</th>
                  <th>Producto</th>
                  <th>Detalles</th>
                  <th>Medida</th>
                  <th>Existencia</th>
                  <th>Total</th>
                  <th>OP</th>
                </tr>
              </thead>
              <tbody>
              </tbody>
              <tfoot>
                <tr>
                  <th>Codigo</th>
                  <th>SAT</th>
                  <th>Marca</th>
                  <th>Producto</th>
                  <th>Detalles</th>
                  <th>Medida</th>
                  <th>Existencia</th>
                  <th>Total</th>
                  <th>OP</th>
                </tr>
              </tfoot>
            </table>              
              
            </div>
            <!-- /.card-body -->
          </div>
<!-- /Datatable -->
	    
          <!-- Contenido Arriba -->
          </div>
        </div>
      </div>
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

<?PHP require 'footer.php'; ?>
<script type="text/javascript" src="scripts/producto.js"></script>