<?PHP require 'header.php'; ?>

<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    
    <section id="inicioPaguina" class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><i class="fas fa-dolly"></i> Resurtir</h1>
          </div>
          <div class="col-sm-6 text-right">
            <b>Iconos y Accion</b>
            <i class="fas fa-plus"></i> Agregar
            <i class="fas fa-save"></i> Salvar
            <i class="fas fa-eye"></i> Mostrar 
            <i class="fas fa-edit"></i> Editar
            <i class="fas fa-ban"></i> Cancelar
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item active">Opciones</li>
              <li class="breadcrumb-item"><a href="#" onclick="mostrarDiv('divFormulario',1);"><i class="fas fa-plus"></i> Resurtir</a></li>
              <li class="breadcrumb-item"><a href="#" onclick="mostrarDiv('divBuscar',1);"><i class="fas fa-search"></i> Buscar Resurtido</a></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-12">
	  <!-- Contenido abajo -->
        
      <!-- Formulario -->
      <form name="formularioX" id="formularioX" method="POST">
        <div class="card" id="divFormulario">
          <div class="card-header">
            <div class="card-header">
              <h4 class="card-title"><i class="fas fa-dolly"></i> Resurtir Producto... </h4>
            </div>
            <div class="row">
              <div class="col-sm-3 form-group">
                <label class="control-label">&nbsp;</label>
                <button id="btnBuscarContribuyente" type="button" class="btn btn-block btn-outline-info" data-dismiss="modal" data-toggle="modal"><i class="fa fa-search"></i> Buscar Proveedor</button>
              </div>
              <div class="col-sm-3 form-group">
                <label class="control-label">R.F.C. del Proveedor:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-building"></i> </span>
                  </div>                  
                  <input name="rfc" id="rfc" list="listarfc" maxlength="13" type="text" class="form-control" placeholder="RFC Proveedor" autocomplete="off" required="">
                  <datalist id="listarfc">
                    <!-- resurtir.js / rfc_keyup -->
                  </datalist>
                </div>
              </div>
              <div class="col-sm-6 form-group">
                <label class="control-label">Nombre del Proveedor:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-industry"></i> </span>
                  </div>
                  <input name="nombreproveedor" id="nombreproveedor" type="text" class="form-control" placeholder="Nombre del Proveedor" autocomplete="off" required="">
                </div>
              </div>
              <div class="col-sm-12 form-group">
                <label class="control-label">Direccion del Proveedor:</label>
                <div class="input-group mb-2">                  
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-bookmark"></i></span>
                  </div>
                  <textarea name="direccionproveedor" id="direccionproveedor" class="form-control" rows="2" placeholder="Direccion del proveedor . . ." title="Notas para el contacto."></textarea>
                </div>
              </div>
              <div class="col-sm-4 form-group">
                <label class="control-label">Buscar Producto:</label>
                <div class="input-group mb-2">
                  <select class="form-control select2 select2-hidden-accessible" style="width: 100%;" data-select2-id="1" tabindex="-1" aria-hidden="true" id="BuscaProducto">
                    <!-- resurtir.js buscarElementoSelect2-->
                  </select>
                </div>
              </div>
              <div class="col-sm-3 form-group">
                <label class="control-label">Codigo de Barras:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-barcode"></i></span>
                  </div>
                  <input name="codigobarras" id="codigobarras" type="text" class="form-control" placeholder="Codigo Barras del Producto" autocomplete="off" required="" onkeyup="validaCodigo();">
                </div>
              </div>
              <div class="col-sm-5 form-group">
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-bookmark"></i></span>
                  </div>
                  <textarea name="descripcion" id="descripcion" class="form-control" rows="2" placeholder="Descripcion del producto . . ." disabled=""></textarea>
                </div>
              </div>
              <div class="col-sm-3 form-group">
                <label class="control-label">Folio de Factura:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-file-invoice-dollar"></i> </span>
                  </div>
                  <input name="facturaproveedor" id="facturaproveedor" maxlength="50" type="text" class="form-control" placeholder="Folio de Factura..." autocomplete="off" required="">
                </div>
              </div>
              <div class="col-sm-3 form-group">
                <label class="control-label">Cantidad a Resurtir:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-box"></i></span>
                  </div>
                  <input name="cantidadproducto" id="cantidadproducto" type="number" min="1" class="form-control" placeholder="Cantidad a resurtir" required="">
                </div>
              </div>
              <div class="col-sm-3 form-group">
                <label class="control-label">Fecha de Caducidad:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="far fa-calendar-alt"></i></span>
                  </div>
                  <input name="caducidad" id="caducidad" type="date" min="<?=date('Y-m-d');?>" class="form-control" placeholder="Caducidad">
                </div>
              </div>
              <div class="col-sm-2 form-group">
                <label class="control-label">Existencia Actual:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-box"></i></span>
                  </div>
                  <input name="existencia" id="existencia" type="text" class="form-control" disabled="">
                </div>
              </div>
              <div class="col-sm-3 form-group">
                <label class="control-label">Cantidad minina en existencia:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-box"></i></span>
                  </div>
                  <input name="existenciaminima" id="existenciaminima" type="number" min="0" class="form-control" placeholder="Existencia Minima?" required="">
                </div>
              </div>
               <div class="col-sm-3">
                <div class="form-group">
                  <label class="control-label">Precio NETO de Compra por Unidad:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-hand-holding-usd"></i></span>
                    </div>
                    <input name="compra" id="compra" type="number" step="0.01" min="0.01" class="form-control" placeholder="Pre. X Unidad" required="">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="control-label">IVA CERO ?:</label>
                  <div class="input-group mb-2">
                    <div class="icheck-success d-inline">
                      <input type="radio" id="ivacero" name="civa" checked="" value="1">
                      <label for="ivacero">Calcula IVA </label>  
                    </div>
                    <div class="icheck-gray d-inline">
                      <input type="radio" id="caliva" name="civa" value="0">
                      <label for="caliva">Sin IVA </label>  
                    </div>
                  </div>
                </div>
              </div>
              
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="control-label">% Ganancia sobre compra:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-percent"></i></span>
                    </div>
                    <input name="ganancia" id="ganancia" type="number" step="0.01" min="0.01" class="form-control" placeholder="% Ganancia" required="" onkeyup="calcular('ganancia');">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="control-label">SubTotal:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-dollar-sign"></i></span>
                    </div>
                    <input name="subtotal" id="subtotal" type="number" step="0.01" class="form-control" placeholder="SubTotal" required="" onkeyup="calcular('subtotal');">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="control-label">IVA:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-dollar-sign"></i></span>
                    </div>
                    <input name="iva" id="iva" type="number" step="0.01" class="form-control" placeholder="I.V.A." required="" onkeyup="calcular('iva');">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-3">
                <div class="form-group">
                  <label class="control-label">Total:</label>
                  <div class="input-group mb-2">
                    <div class="input-group-prepend">
                      <span class="input-group-text"> <i class="fas fa-dollar-sign"></i></span>
                    </div>
                    <input name="total" id="total" type="number" step="0.01" class="form-control" placeholder="Total" required="" onkeyup="calcular('total');">
                  </div>
                </div>
              </div>
              
              <div class="col-sm-3"><!-- Separacion --></div>
              <div class="col-sm-6"><!-- Separacion --></div>
              <div class="col-sm-3">
                <div class="input-group mb-2">
                  <button type="submit" class="btn btn-block btn-outline-info" id="btnGuardar"><i class="fas fa-save"></i> Resurtir Producto</button>
                </div>
              </div>
              <div class="col-sm-3">
                <div class="input-group mb-2">
                  <button type="button" class="btn btn-block btn-outline-secondary" id="btnCancelar" onclick="window.location.href = '#inicioPaguina';">
                    <i class="fas fa-dolly"></i> Cancelar
                  </button>
                  <input type="hidden" name="existerfc" id="existerfc">
                </div>
              </div>
            </div>
            
          </div>
        </div>
      </form>
      <!-- /Formulario -->
      
      <!-- datatable -->
        <div class="card" id="divBuscar">
          <div class="card-header">
            <div class="card-header">
              <form name="formBuscar" id="formBuscar" method="POST">
                <div class="row">                
                  
                  <div class="col-sm-3">
                    <label>Indicar codigo de producto...</label>
                    <div class="input-group mb-2">
                      <div class="input-group-prepend">
                        <span class="input-group-text"> <i class="fas fa-search"></i> </span>
                      </div>
                      <input name="buscar" id="buscar" type="text" class="form-control" placeholder="Indica el codigo del producto" autocomplete="off" autofocus="">
                    </div>
                  </div>
                  <div class="col-sm-3">
                    <label>&blacktriangleright;</label>
                    <div class="input-group mb-2">
                      <button type="button" class="btn btn-block btn-outline-info" id="btnBuscar"><i class="fas fa-search"></i> Buscar...</button>
                    </div>
                  </div>    

                </div>
              </form>
            </div>            
            <div class="card-body">
              <div class="row">
                <table class="table table-bordered" id="DataTable">
                  <thead>
                    <tr>
                      <th>Fecha</th>
                      <th>Factura</th>
                      <th>Proveedor</th>
                      <th>Producto</th>
                      <th>Cantidad</th>
                      <th>Caducidad</th>
                      <th>EP</th>
                      <th>Compra</th>
                      <th><i class="fas fa-edit"></i></th>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                  <tfoot>
                    <tr>
                      <th>Fecha</th>
                      <th>Factura</th>
                      <th>Proveedor</th>
                      <th>Producto</th>
                      <th>Cantidad</th>
                      <th>Caducidad</th>
                      <th>EP</th>
                      <th>Compra</th>
                      <th><i class="fas fa-edit"></i></th>
                    </tr>
                  </tfoot>
                </table>
              </div>
            </div>            
          </div>
        </div>
      <!-- /datatable -->
      
      
      
      <div class="card card-info" id="divEventos" style="">        
      <div class="card-body p-0">
        <table class="table table-striped">
          <thead>            
            <tr class="text-blue">
              <th>Fecha&Hora de Registro</th>
              <th>Factura</th>
              <th>Proveedor</th>
              <th>Producto</th>
              <th>Cantidad</th>
              <th>Caducidad</th>
              <th title="Existencia de Producto">EP</th>
              <th>Compra</th>
            </tr>
          </thead>
          <tbody id="listaEventos">
          </tbody>
        </table>
      </div>
      <!-- /.card-body -->
    </div>
	    
          <!-- Contenido Arriba -->
          </div>
        </div>
      </div>
    </section>
    <!-- /.content -->
    
    
    <!-- Modales -->
      <div class="modal fade" id="modalEditaResurtir">
        <div class="modal-dialog modal-mg">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title"><i class="fas fa-edit"></i> Editar Resurtido.</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
              <div class="col-sm-12 form-group">
                <label class="control-label">Cantidad correcta a resurtir:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="fas fa-box"></i></span>
                  </div>
                  <input name="cantidadproductoedita" id="cantidadproductoedita" type="number" min="1" class="form-control" placeholder="Cantidad a resurtir">
                  <input name="cantidadproductoantes" id="cantidadproductoantes" type="hidden">
                  <input name="idresurtir" id="idresurtir" type="hidden">
                  <input name="idproducto" id="idproducto" type="hidden">
                </div>
              </div>
              <div class="col-sm-12 form-group">
                <label class="control-label">Fecha de Caducidad correcta:</label>
                <div class="input-group mb-2">
                  <div class="input-group-prepend">
                    <span class="input-group-text"> <i class="far fa-calendar-alt"></i></span>
                  </div>
                  <input name="caducidadedita" id="caducidadedita" type="date" min="<?=date('Y-m-d');?>" class="form-control" placeholder="Caducidad">
                </div>
              </div>
            </div>
            <div class="modal-footer float-left">
              <button id="btnEditarResurtir" type="button" class="btn btn-block btn-outline-info"><i class="fas fa-search"></i> Guardar Edicion...</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
      <!-- /.modal -->
<!-- /Modales -->
  </div>
  <!-- /.content-wrapper -->
  
  <div id="modalBuscaContribuyente" class="modal fade">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h2 class="modal-title text-info"><i class="fas fa-dolly"></i> Buscar contribuyente</h2>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body text-center">         
          <div class="input-group mb-3">
            <div class="input-group-prepend">
              <span class="input-group-text"><i class="fas fa-user-alt"></i></span>
            </div>
            <input type="text" name="buscaContribuyente" id="buscaContribuyente" class="form-control" placeholder="Indique un parametro para buscar...">
          </div>
          
          <table class="table table-striped">            
            <thead>
              <tr class="text-blue">
                <th>RFC</th>
                <th>Nombre</th>
                <th>Direccion</th>
                <th>-</th>
              </tr>
            </thead>
            <tbody id="listaContribuyente">
            </tbody>
        </table>
          
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->

<?PHP require 'footer.php'; ?>
<script type="text/javascript" src="scripts/resurtir.js"></script>