var DataTable; //Variable para dataTable.
var toastr; //Varible de alertas
var ajaxFile = 'buscaVenta'; //Variable para archivo de ajax.
var camposForm = ['rfc', 'nombre', 'direccion', 'mfemail', 'mfemail2'];

//Funcion que se ejecuta al inicio
function iniciar(){
  $('#modalFormFactura').on('submit',function(e){ //si se activa el evento submit llamma funcion ...
    solicitarFactura(e);
  });
  $('#divEventos').hide();
}

$('#btnBuscar').click(function(){
  $('#divEventos').fadeOut(2000);
  listarRegistros();
});

function listarRegistros(){
  var c = $('#buscar').val();
  var fi = $('#fechainicio').val();
  var ff = $('#fechafin').val();
  toastr.info('Buscando...');
  
  DataTable = $('#DataTable').dataTable({
    "aProcessing": true, //Activa el procedimietno del DataTables
    "aServerSide": true, //Paginación y filtrado realizados por el servidor
    dom: 'Bfrtip', //Definimos los elementos del control de tabla
    buttons:['copyHtml5','excelHtml5','csvHtml5','pdf'],
    "ajax":{
      url: 'ajax/' +ajaxFile+ '.php?op=Buscar&c='+c+'&fi='+fi+'&ff='+ff, //Obtener los valores desde url
      type: "POST",
      dataType: "json", //Datos codificados mediante json
      error:function(e){ //en caso de errores
        console.log(e.responseText);
      }
    },
    "createdRow": function( row, data, dataIndex ) { //Establecer color a las filas
      //condiciones
      var varColn = 8;
      if(data[varColn] === '1'){
        $(row).css('background-color','rgba(0, 123, 255, .1)');
      }
      if(data[varColn] === '2'){
        $(row).css('background-color','rgba(255, 193, 7, .1)');
      }
      if(data[varColn] === '3'){
        $(row).css('background-color','rgba(40, 167, 69, .1)');
      }
      if(data[varColn] === '4'){
        $(row).css('background-color','rgba(220, 53, 69, .1)');
      }
      if(data[varColn] === '5'){
        $(row).css('background-color','rgba(108, 117, 125, .1)');
      }
    },
    "bBestroy": true,
    "destroy": true,
    "iDisplayLength": 10, //Paginacion de X en X registros.
    "order": [[0, "desc"]] //Ordenar (columna,orden).
  }).DataTable();
}

function listaEventos(id){
  $('#divEventos').fadeIn(2000);
  $('.listaEventos').remove(); //Borrar etiquetas extras 
  
  $.get("ajax/" +ajaxFile+ ".php?op=listaEventos",{id : id}, function(data, status){
    //console.log(data);
    var separar = data.split('#R'); //Separa en arreglo Var1,Var2,etc..
    $('#listaEventos').append(separar[0]); //Agrega html a id
    $('#nventa').html('Venta #'+id); //Agrega html a id
    $('#fechaventa').html('Fecha de Venta '+separar[1]); //Agrega html a id
    $('#vendedor').html('Vendedor: '+separar[2]); //Agrega html a id
    $('#TipoPago').html(separar[3]); //Agrega html a id
    $('#Numeros').html(separar[4]); //Agrega html a id
    toastr.info('Desgloce de Venta #'+id+'...');
  });
}

function mailVenta(venta){
  $('#idventa').val(venta);
  $('#modalMail').modal('show');
  $('#mailVentaTitulo').html('¿Enviar venta #'+venta+' por correo?');
  $('#email').val(null);
}

$('#btnMail').click(function(){
  var email = $('#email').val();  
  var venta = $('#idventa').val();  
  var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
  
  if(regex.test(email) !== false){
    var jqxhr = $.post('ajax/'+ajaxFile+ ".php?op=VentaMail",{email:email, venta:venta},function(r){
      if(r !== ''){
        console.log(r);
      }
    })
    .done(function() {
      toastr.success('Correo enviado a '+email);
      $('#modalMail').modal('hide');    
      $('#email').val(null);
      //$('#idventa').val(null);
    })
    .fail(function() {
      toastr.error('Error jQuery btnMail. . .');
    });
  }else{
    toastr.warning('Ingrese un correo valido...');
  }
});

function facturaVenta(venta){
  $('#idventa').val(venta);
  $('#modalFactura').modal('show');
  $('#modalFacturaTitulo').html('¿Solicitar factura para la venta #'+venta+'?');
  
  for(var i=0; i<camposForm.length; i++){
    $("#"+camposForm[i]).val(null);
  }
}

function solicitarFactura(e){
  e.preventDefault(); //Para que no se active la accion predeterminad del evento
  
  //$("#btnGuardar").prop("disabled",true);
  var formDatos = new FormData($("#modalFormFactura")[0]); //Para obtener los datos del id=formularioX  
  $.ajax({ //Metodo ajax
    url: "ajax/" +ajaxFile+ ".php?op=solicitarFactura", //archivo donde lo envia
    type: "POST",
    data: formDatos, //La varible var formData = new FormData mas arriba
    contentType: false,
    processData: false,
        
    success: function(respuesta){
      //console.log(respuesta); // Ver consulta
      
      var separar = respuesta.split(','); //Separa en arreglo Var1,Var2,etc..
      if(separar[0] === 'success'){
        toastr.success(separar[1]);
        $('#modalFactura').modal('hide');
      }
      if(separar[0] === 'warning'){ toastr.warning(separar[1]); }
      if(separar[0] === 'error'){ 
        console.log(respuesta);
        toastr.error(separar[1]);
      }
    }
  });
}

$('#rfc').keyup(function(){
  validaRFC();
});
$('#rfc').change(function(){
  validaRFC();
});

function validaRFC(){
  var rfc = $('#rfc').val();
  $('#existerfc').val(null);
  
  if(rfc.length > 2){
    $.post("ajax/" +ajaxFile+ ".php?op=validaRFC",{ rfc:rfc }, function(respuesta, status){
      
      //console.log(respuesta);
      var separar = respuesta.split('#'); //Separa en arreglo Var1,Var2,etc..
      if(separar[0] === '1'){
        $('#existerfc').val(separar[1]);
        $('#rfc').val(separar[1]);
        $('#nombre').val(separar[2]);
        $('#direccion').val(separar[3]);
        $('#mfemail').val(separar[4]);
        $('#mfemail2').val(separar[5]);
      }if(separar[0] === '2'){
        $("#listarfc").html(separar[1]);
        $('#existerfc').val(null);
        $('#nombre').val(null);
        $('#direccion').val(null);
        $('#mfemail').val(null);
        $('#mfemail2').val(null);
      }      
    });    
  }
}

iniciar();