var DataTable; //Variable para dataTable.
var toastr; //Varible de alertas
var ajaxFile = 'ajax/cajaChica.php'; //Variable para archivo de ajax.

//Funcion que se ejecuta al inicio
function iniciar(){
  corteCaja();
  listarRegistros();
}

function listarRegistros(){
  DataTable = $('#DataTable').dataTable({
    "aProcessing": true, //Activa el prosedamietno del datatables
    "aServerSide": true, //Paginacion y filtrado realizados por el servidor
    dom: 'Bfrtip', //Definimos los elementos del control de tabla
    buttons:['copyHtml5','excelHtml5','csvHtml5','pdf'],
    "ajax":{
      url: ajaxFile+ '?op=listar', //Obtener los valores desde url
      type: "get",
      dataType: "json", //Datos codificados mediante json
      error:function(e){ //en caso de errores
	//console.log(e.responseText);
      }
    },
    "createdRow": function( row, data, dataIndex ) { //Establecer color a las filas
      //Condiciones
      var varColn = 4;
      if(data[varColn] === '3'){
        $(row).css('background-color','rgba(0, 123, 255, .3)'); //azul - primary
      }
      if(data[varColn] === '2'){
        $(row).css('background-color','rgba(255, 193, 7, .3)'); //amarillo - warning
      }
      if(data[varColn] === 'A'){
        $(row).css('background-color','rgba(102, 16, 242, .3)'); //indigo - indigo
      }
      if(data[varColn] === 'A'){
        $(row).css('background-color','rgba(23, 162, 184, .3)'); //perry - info
      }      
      if(data[varColn] === '1'){
        $(row).css('background-color','rgba(40, 167, 69, .3)'); //verde - success
      }
      if(data[varColn] === 'A'){
        $(row).css('background-color','rgba(230, 230, 230, .3)'); //gris - default
      }
      if(data[varColn] === '0'){
        $(row).css('background-color','rgba(220, 53, 69, .3)'); //rojo - danger
      }
    },
    "bBestroy": true,
    "iDisplayLength": 30, //Paginacion de X en X registros.
    "order": [[0, "desc"]] //Ordenar (columna,orden).
  }).DataTable();
}

$('#btnCajaChica').click(function(){
  var monto = $('#monto').val();
  var accion = $("input[type='radio'][name='accion']:checked").val();
  var descripcion = $('#descripcion').val();
  
  if(monto >= 0){
    //console.log(monto,accion,descripcion);
    var jqxhr = $.post(ajaxFile+ "?op=agregarCajaChica",
      {monto:monto, accion:accion, descripcion:descripcion}, function (r){
      //console.log(r);
    })
    .done(function(r) {
      if(accion === '0'){
        monto = '-'+monto;
        toastr.success('Monto $'+monto+' registrado.');
      }else if(accion === '2'){
        toastr.success('Se registro el Corte de Caja por $'+monto);
      }else if(accion === '1'){
        toastr.warning('El Monto de caja chica se ajusto en $'+monto);
      }

      $('#monto').val(null);
      $('#accion').val(null);
      $('#descripcion').val(null);
      $("#gasto").attr('checked',true);    
      corteCaja();
      DataTable.ajax.reload();
    })
    .fail(function(r) {
      console.log(r);
      toastr.error('jQuery Agregar Caja Chica . . .');
    });
  }else{
    toastr.warning('Indique un monto para registrar');
  }
    
});

function corteCaja(){
  var jqxhr = $.post(ajaxFile+ "?op=corteCaja", function (resultado){
    //console.log(resultado);
  })
  .done(function(resultado) {
    $('#corteCaja').html(resultado);
  })
  .fail(function(resultado) {
    console.log(resultado);
    toastr.error('jQuery Corte de Caja . . .');
  });
}

$('input:radio[name=accion]').change(function(){
  var accion = $('input:radio[name=accion]:checked').val();
  
  if(accion === '0'){
    $('#btnCajaChica').removeClass('btn-outline-warning')
            .removeClass('btn-outline-primary')
            .addClass('btn-outline-danger');
    $('#btnCajaChica').html('<i class="fas fa-hand-holding-usd"></i> Registrar Gasto');
    $('#labelAccion').html('Descripcion del gasto:');
  }
  
  if(accion === '1'){
    $('#btnCajaChica').removeClass('btn-outline-danger')
            .removeClass('btn-outline-primary')
            .addClass('btn-outline-warning');
    $('#btnCajaChica').html('<i class="fas fa-donate"></i> Ajustar Monto de Caja');
    $('#labelAccion').html('Descripcion del ajuste de caja:');
  }
  
  if(accion === '2'){
    $('#btnCajaChica').removeClass('btn-outline-danger')
            .removeClass('btn-outline-warning')
            .addClass('btn-outline-primary');
    $('#btnCajaChica').html('<i class="fas fa-hand-holding-usd"></i> Corte de Caja');
    $('#labelAccion').html('Notas para el corte de caja:');
  }
  
});

iniciar(); //Ejecuta iniciar, para que simpre se ejecute.