var DataTable; //Variable para dataTable.
var Swal, toastr; //Varible de alertas
var ajaxFile = 'control'; //Variable para archivo de ajax.
var camposForm = ['archivoLogo'];

//Funcion que se ejecuta al inicio
function iniciar(){
  $('#formLogo').on('submit',function(e){ //si se activa el evento submit llamma funcion ...
    subirLogo(e);
  });  
  $('#formTicket').on('submit',function(e){ //si se activa el evento submit llamma funcion ...
    formTicket(e);
  }); 
  ticketMuestra();
  limpiar();
  listarRegistros();  
}

function limpiar(){
  for(var i=0; i<camposForm.length; i++){
    $("#"+camposForm[i]).val(null);
  }
  $('#nombreLogo').html('Clic para seleccionar imagen...');  
}

function fileName(){ //Cambiar el nombre en el input de archivo
  var fn = $('#archivoLogo').val();
  $('#nombreLogo').html(fn);
}

function subirLogo(e){
  e.preventDefault(); //Para que no se active la accion predeterminad del evento
  
  var formDatos = new FormData($("#formLogo")[0]); //Para obtener los datos del id=formularioX
  $.ajax({ //Metodo ajax
    url: "ajax/" +ajaxFile+ ".php?op=subirLogo", //archivo donde lo envia
    type: "POST",
    data: formDatos, //La varible var formData = new FormData mas arriba
    contentType: false,
    processData: false,
        
    success: function(respuesta){
      //console.log(respuesta); // Ver consulta
      var separar = respuesta.split(','); //Separa en arreglo Var1,Var2,etc..
      if(separar[0] === 'success'){ 
        toastr.success(separar[1]);
        limpiar();
        $('.logoU').attr('src','imagenes/'+separar[2]);
        $('#sizeAplica').attr('src','imagenes/'+separar[2]);
      }
      if(separar[0] === 'warning'){ toastr.success(separar[1]); }
      if(separar[0] === 'error'){ 
        console.log(respuesta);
        toastr.error(separar[1]);
      }
    }
  });  
}

function formTicket(e){
  e.preventDefault(); //Para que no se active la accion predeterminad del evento
  
  var formDatos = new FormData($("#formTicket")[0]); //Para obtener los datos del id=formularioX
  $.ajax({ //Metodo ajax
    url: "ajax/" +ajaxFile+ ".php?op=formTicket", //archivo donde lo envia
    type: "POST",
    data: formDatos, //La varible var formData = new FormData mas arriba
    contentType: false,
    processData: false,
        
    success: function(respuesta){
      console.log(respuesta); // Ver consulta
      var separar = respuesta.split(','); //Separa en arreglo Var1,Var2,etc..
      if(separar[0] === 'success'){ 
        toastr.success(separar[1]);
        limpiar();
      }
      if(separar[0] === 'warning'){ toastr.success(separar[1]); }
      if(separar[0] === 'error'){ 
        console.log(respuesta);
        toastr.error(separar[1]);
      }
    }
  });  
}

function listarRegistros(){
  var jqxhr = $.post("ajax/" +ajaxFile+ ".php?op=listar", function(data, status){    
    //console.log(data);
  })
  .done(function(data) {
    data = JSON.parse(data);
    $('#nombre').html(data.nombre);
    $('#cuenta').html('Cuenta '+data.usuario+' con '+data.usuactivos+' <i class="fas fa-user"></i> activo(s).');
    $('#registro').html('Registro '+data.registro);
    $('.vigencia').html(data.vigencia);
    $('#restantes').html('Dias restantes '+data.restantes);
    if(data.restantes <= 1){ $('#smallbox').addClass(' bg-danger'); }
    if(data.restantes > 1 && data.restantes < 28){ $('#smallbox').addClass(' bg-warning'); }
    if(data.restantes > 28){ $('#smallbox').addClass(' bg-success'); }
    $('#cobrar').html('$'+data.cobrar+'-');
    $('#usuario').html('por <i class="fas fa-user"></i> '+data.usuactivos+' usuario activo(s)');
    $('.logoU').attr('src','imagenes/L'+data.idcontrol+'.'+data.logoext);
    
    //Data de Ticket hay que separ el resultado de php _._
    var separar = data.formatoticket.split('_._'); //Separa en arreglo Var1,Var2,etc..
    sizeLogo(separar[0]);
    $('#sizelogo').val(separar[0]);
    for(var i=1; i<=6; i++){
      $('#L'+i).html(separar[i]);    
      $('#linea'+i).val(separar[i]);
    }
    //Mostrar codigo de Producto
    $("input[type='radio'][name='mcp'][value='"+separar[7]+"']").prop("checked", true);
    if(separar[7] === '0'){ $('.vc').hide(); }
    
    if(data.devolucion == null){
      $("#ndiasc option[value='15']").attr("selected",true);
    }else{
      $("#ndiasc option[value='"+ data.devolucion +"']").attr("selected",true);
    }
    
  })
  .fail(function() {
    toastr.error('jQuery listarRegistros . . .');
  });
}

function ticketMuestra(){
  $.post("ajax/" +ajaxFile+ ".php?op=ticketMuestra", function(data){    
    $('#ticketMuestra').html(data);
  });  
}

$('#sizelogo').mousemove(function(){
  var r = this.value;
  sizeLogo(r);
});
$('#sizelogo').change(function(){
  var r = this.value;
  sizeLogo(r);
});

function sizeLogo(r){
  $('#sizepxlogo').html('Tamaño de Logotipo '+r+'px');
  $('#sizeAplica').css('max-width', r+'px');
  $('#sizeAplica').css('max-height', r+'px');
}

$("input[type='text']").keyup(function(){
  for(var i=1; i<=6; i++){
    $('#L'+i).html($('#linea'+i).val());    
  }
});

$("input[type='radio'][name='mcp']").click(function(){
  //console.log($("input[type='radio'][name='mcp']:checked").val());
  var r = $("input[type='radio'][name='mcp']:checked").val();
  if(r === '1'){ $('.vc').show(); }
  else{ $('.vc').hide(); }
});

function actualizaNdias(nDiasC){
  var jqxhr = $.post("ajax/" +ajaxFile+ ".php?op=actualizaNdias", {nDiasC:nDiasC}, function(data, status){
    //console.log(data);
  })
  .done(function(data) {
    var separar = data.split(','); //Separa en arreglo Var1,Var2,etc..
    if(separar[0] === 'success'){ 
      toastr.success(separar[1]);
    }
    if(separar[0] === 'warning'){ toastr.success(separar[1]); }
    if(separar[0] === 'error'){ 
      console.log(respuesta);
      toastr.error(separar[1]);
    }    
  })
  .fail(function() {
    toastr.error('jQuery listarRegistros . . .');
  });
}

iniciar(); //Ejecuta iniciar, para que simpre se ejecute.