var DataTable; //Variable para dataTable.
var toastr; //Varible de alertas
var ajaxFile = 'reporteVenta'; //Variable para archivo de ajax.
var Encabezado = [
        ['Cod.Producto','Cod.SAT','Producto','Cantidad','SubTotal','IVA','Total','Facturado a'],
        ['Venta','Fecha','Cod.Producto','Cod.SAT','Producto','Cantidad','SubTotal','IVA','Total','Facturado a']
    ];
//Funcion que se ejecuta al inicio
function iniciar(){
}

$('#btnBuscar').click(function(){
  var c = $("input[type='radio'][name='tc']:checked").val();
  $('.encabezado').html(null);
  for(var i=0; i<Encabezado[c].length; i++){
    $('.encabezado').append('<th>'+Encabezado[c][i]+'</th>');
  }
  $("input[type='radio'][name='tc']").attr('disabled',true);
  listarRegistros(c);
});

function listarRegistros(c){
  var fi = $('#fechainicio').val();
  var ff = $('#fechafin').val();
  var OP; 
  
  if(c === '0') OP = 'Fecha';
  if(c === '1') OP = 'VentaFecha';

  
  DataTable = $('#DataTable').dataTable({
    "aProcessing": true, //Activa el procedimietno del DataTables
    "aServerSide": true, //Paginación y filtrado realizados por el servidor
    dom: 'Bfrtip', //Definimos los elementos del control de tabla
    buttons:['copyHtml5','excelHtml5','csvHtml5','pdf'],
    "ajax":{
      url: 'ajax/' +ajaxFile+ '.php?op='+OP+'&fi='+fi+'&ff='+ff, //Obtener los valores desde url
      type: "POST",
      dataType: "json", //Datos codificados mediante json
      error:function(e){ //en caso de errores
        console.log(e.responseText);
      }
    },
    "createdRow": function( row, data, dataIndex ) { //Establecer color a las filas
      //condiciones´
      var codigo,cont;
      if(c === '0'){ codigo=1; cont=7; }
      if(c === '1'){ codigo=3; cont=9; }
      
      if(data[codigo] !== ''){
        $(row).css('background-color','rgba(40, 167, 69, .1)'); //verde
      }
      if(data[cont] !== null){
        $(row).css('background-color','rgba(255, 193, 7, .1)'); //amarillo
      }
    },
    "bBestroy": true,
    "destroy": true,
    "iDisplayLength": 20, //Paginacion de X en X registros.
    "order": [[0, "desc"]] //Ordenar (columna,orden).
  }).DataTable();
  
  
 
}

iniciar();