var DataTable; //Variable para dataTable.
var ajaxFile = 'usuario'; //Variable para archivo de ajax.
var camposForm = ['nombre', 'email', 'password', 'confirma','usuarioP']; //Nombre de ID en doc php form.
var dualListObj;

//Funcion que se ejecuta al inicio
function iniciar(){
  $('#formDatosX').on('submit',function(e){ //si se activa el evento submit llamma funcion ...
    guardaryeditar(e);
  });  
  listarRegistros();
  limpiar();
}

function limpiar(){
  //Se usa Gquery $("#NombreDelObjeto).val("Valor a mandar");
  for(i=0; i<camposForm.length; i++){
    $("#"+camposForm[i]).val(null);
    $("#"+camposForm[i]).prop('disabled',false); //Desactivar elemento
  }
}

function verPermiso(usuario){
  $('#permiso').empty();
  $('#usuarioP').val(usuario);
  
  $.post("ajax/" +ajaxFile+ ".php?op=verPermiso", {usuario:usuario}, function(r){
    //console.log(r); //comentar
    //Obtenermos los <option>
    $('#permiso').append(r);
    
    //Iniciamos el bootstrapDualListbox al hacer clic
    //https://programmerclick.com/article/2301771212/
    dualListObj = $('.duallistbox').bootstrapDualListbox({
      nonSelectedListLabel: 'Sin permiso', // Etiqueta de lista no seleccionada, valor predeterminado falso;
      selectedListLabel: 'Permiso', // Etiqueta de la lista seleccionada, por defecto false;
      showFilterInputs: false, // Si se muestra el cuadro de entrada de entrada filtrada, el valor predeterminado es verdadero; si es falso, el contenido relacionado con el filtrado no funciona y no se muestra
      //filterTextClear: 'Borrar condición de filtro', // Borrar el texto del botón de filtro, el valor predeterminado es 'mostrar todo', se puede reemplazar con otro texto;
      //filterPlaceHolder: 'Filter condition', // Marcador de posición del cuadro de entrada de la condición del filtro, contenido personalizable, el valor predeterminado es 'Filter',
      //nonSelectedFilter: 'ion ([7-9] | [1] [0-2])', // La condición del filtro de la opción no seleccionada, el valor predeterminado es una cadena vacía '', también puede usar métodos regulares, por ejemplo: 'ion ([ 7-9] | [1] [0-2]) 'Filtro 7, 8, 9, 10, 11, 12;
      //selectedFilter: '3', // La condición del filtro de la opción seleccionada, el valor predeterminado es una cadena vacía ''; Referencia: nonSelectedFilter; generalmente no establece la condición del filtro seleccionado, hará que algunos elementos seleccionados no estén en la condición del filtro de la opción seleccionada No se puede mostrar dentro del rango;
      moveOnSelect: false, // si se mueve la opción seleccionada; cuando es falsa, los botones de moveSelected y removeSelected se muestran y surten efecto; el valor predeterminado es verdadero; verdadero es que solo el cursor se puede seleccionar continuamente, suelte el mouse, el elemento seleccionado se moverá; si es falso Se puede usar con Ctrl y Shift del teclado. Haga clic en los botones de moveSelectedLabel y removeSelectedLabel, la opción se moverá;
      moveAllLabel: 'Agregar todas las opciones', // Agregar la etiqueta de todos los botones de opción, el valor predeterminado es 'Mover todo'
      moveSelectedLabel: 'Agregar opción seleccionada', // Agregar etiqueta del botón de opción seleccionado, predeterminado 'Mover seleccionado'
      removeAllLabel: 'Eliminar todas las opciones', // Eliminar la etiqueta de todos los botones de opciones, el valor predeterminado es 'Eliminar todo'
      removeSelectedLabel: 'Eliminar la opción seleccionada', // Eliminar la etiqueta del botón de opción seleccionado, el valor predeterminado es 'Eliminar seleccionado'
      //preserveSelectionOnMove: cuando 'movió', // 'movió' o 'todos', muestra los elementos movidos a la lista de destino (visualización del color de fondo), el valor predeterminado es falso, no se muestra; no ve la diferencia entre 'movido' y 'todos';
      //helperSelectNamePostfix: '_ ast', // El sufijo del nombre del selector es'_helper ', después de que la lista no seleccionada se cose 1, la costura seleccionada 2; también se puede modificar mediante el método setHelperSelectNamePostfix (valor, actualización);
      //selectorMinimalHeight: 260, // La altura mínima del selector, cuando es inferior a 260 px, el valor predeterminado es una altura fija, y un valor mayor aumentará la altura del selector; no sé el tamaño del valor predeterminado y la unidad de altura
      infoText: 'Total de opciones seleccionadas / no seleccionadas {0} elementos', // Cuando no se filtra, elementos totales de opciones seleccionadas / no seleccionadas; el valor predeterminado es 'Mostrar todo {0}';
      //infoTextFiltered: 'Filtrar {0} elementos de {1} elementos, // filtrar información, el valor predeterminado es' <span class = "label label-warning"> Filtered </span> {0} from {1} '. Filtra n elementos de m elementos;
      infoTextEmpty: 'Lista vacía' // cuando la condición del filtro es '', y el contenido que se muestra cuando la lista seleccionada / no seleccionada no tiene opciones; el valor predeterminado es 'Lista vacía';
      //filterOnValues: false // No sé el rol específico por el momento
    });
    dualListObj.bootstrapDualListbox('refresh'); //Refrescar la dualListObj
  });
}

function modificaPermiso(){  
  var seleccion = [];
  var res = '';
  var usuario = $('#usuarioP').val();
 
  //Obtener los valores seleccionados del select multiple
  $('#permiso :selected').each(function(i, selected){
    seleccion[i] = $(selected).val();
  });
  
  //Los combierto a una cadena para enviarlos tex,tex,etc...
  $.each(seleccion, function (i, elemento) {
    res = res + elemento + ',';
  });
  
  $.post("ajax/" +ajaxFile+ ".php?op=modificaPermiso", {usuario:usuario,'permiso':res}, function(r){
    //console.log(r);
    separar = r.split(','); //Separa en arreglo Var1,Var2,etc..
    if(separar[0] === 'success'){ toastr.success(separar[1]); }
    if(separar[0] === 'error'){
      toastr.error(separar[1]);
      console.log(res);
    }
  });
}

function guardaryeditar(e){
  e.preventDefault(); //Para que no se active la accion predeterminad del evento
  
  //$("#btnGuardar").prop("disabled",true);
  var formDatos = new FormData($("#formDatosX")[0]); //Para obtener los datos del id=formularioX
  $.ajax({ //Metodo ajax
    url: "ajax/" +ajaxFile+ ".php?op=guardaryeditar", //archivo donde lo envia
    type: "POST",
    data: formDatos, //La varible var formData = new FormData mas arriba
    contentType: false,
    processData: false,
        
    success: function(respuesta){
      //console.log(respuesta);
      separar = respuesta.split(','); //Separa en arreglo Var1,Var2,etc..
      
      if(separar[0] === 'success'){ toastr.success(separar[1]); }
      if(separar[0] === 'error'){ 
        toastr.error(separar[1]);
        console.log(respuesta);
      }
      
      DataTable.ajax.reload();
    }
  });
  limpiar();
}

function listarRegistros(){
  DataTable = $('#DataTable').dataTable({
    "aProcessing": true, //Activa el prosedamietno del datatables
    "aServerSide": true, //Paginacion y filtrado realizados por el servidor
    dom: 'Bfrtip', //Definimos los elementos del control de tabla
    buttons:['copyHtml5','excelHtml5','csvHtml5','pdf'],
    "ajax":{
      url: 'ajax/' +ajaxFile+ '.php?op=listarRegistro', //Obtener los valores desde url
      type: "get",
      dataType: "json", //Datos codificados mediante json
      error:function(e){ //en caso de errores
	console.log(e.responseText);
      }
    },    
    "bBestroy": true,
    "iDisplayLength": 10, //Paginacion de X en X registros.
    "order": [[3, "desc"]] //Ordenar (columna,orden).
  }).DataTable();
}

function validaPassword(){
  var u = $('#email').val();
  var p = $('#password').val();
  var c = $('#confirma').val();
  var html = '';
  
  if(u == p){
    html = '- El Password no puede ser igual al usuario.<br>';
    $('#btnGuardar').prop('disabled', true);
  }
  if(p.length < 6 ){
    html = '- Password es demaciado corto ponga al menos 6 caracteres.<br>';
    $('#btnGuardar').prop('disabled', true);
  }
  if(p != c ){
    html = html + '- Los Password no coinciden verifiquelos.<br>';
    $('#btnGuardar').prop('disabled', true);
  }else{
    $('#btnGuardar').prop('disabled', false);
  }
    
  $('#aviso').html(html);
}

function ActDes(control,estado){
  $.post("ajax/" +ajaxFile+ ".php?op=ActDes", {estado:estado,control:control}, function(r){
    separar = r.split(','); //Separa en arreglo Var1,Var2,etc..
    if(separar[0] === 'success'){ toastr.success(separar[1]); }
    if(separar[0] === 'warning'){ toastr.warning(separar[1]); }
    if(separar[0] === 'error'){
      toastr.error(separar[1]);
      console.log(r);
    }
    DataTable.ajax.reload();
  });
}

iniciar(); //Ejecuta iniciar, para que simpre se ejecute.