<?php 
$arbolDirectorio = '../';
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta http-equiv="x-ua-compatible" content="ie=edge">

  <title>Bienbenido a One Punto de Venta</title>
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="<?=$arbolDirectorio;?>public/plugins/fontawesome-free/css/all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?=$arbolDirectorio;?>public/dist/css/adminlte.min.css">
  <!-- Toastr -->
  <link rel="stylesheet" href="<?=$arbolDirectorio;?>public/plugins/toastr/toastr.min.css">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="<?=$arbolDirectorio;?>public/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="icon" href="../imagenes/iconoPV.png" />
  <script type="text/javascript">
    function fsrc(ruta){
      $('#seleccion').attr('src','archivos/pv'+ruta+'.png');
      
      for(var rc=0; rc<=5; rc++){
       $('#imagenDiv'+rc).removeClass(' active'); 
      }
      
      $('#imagenDiv'+ruta).addClass(' active');
    }
    
    cambiaImg();
    
    function cambiaImg(){
      setTimeout(function (){
        let img = Math.floor((Math.random() * 14));
        if(img == 0) img = 1;
       $('#seleccion').attr('src','archivos/pv'+img+'.png');
       toastr.info(img);
       cambiaImg();
      }, 10000);
    }
  </script>
</head>
<body class="hold-transition layout-top-nav layout-navbar-fixed layout-footer-fixed">
<div class="wrapper">

  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand-md navbar-light navbar-white">
    <div class="container">
      <h1><i class="fas fa-cash-register"></i> one Punto Venta</h1>
      
      <button class="navbar-toggler order-1" type="button" data-toggle="collapse" data-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
       
    </div>
  </nav>
  <!-- /.navbar -->

  <!-- Main content -->
  <div class="content-wrapper">
    
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-0"></div>
      </div><!-- /.container-fluid -->
    </section>
    
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-12">
            <h1>La solución de Software que necesitas un punto de venta que sirve para gestionar tu negocio.</h1>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    
    <section class="content">

      <!-- Default box -->
      <div class="card card-solid">
        <div class="card-body">
          <div class="row">
            <div class="col-12 col-sm-6">
              <h3 class="d-inline-block d-sm-none">La Terminal Punto de Venta para tu Negocio.</h3>
              <div class="col-12">
                <img id="seleccion" src="archivos/pv<?= random_int(2, 14);?>.png" class="product-image">
              </div>
              <div class="col-12 product-image-thumbs">
<?php for($i=1; $i<=5; $i++):
  
  $valor = random_int(2, 14);
  
  if(in_array($valor, $pv)){
    $pv[$i] = random_int(2, 14);
  } else {
      $pv[$i] = $valor;
  } 
  ?>
                <div id="imagenDiv<?=$i;?>" class="product-image-thumb">
                  <img src="archivos/pv<?=$pv[$i];?>.png" class="product-image" onclick="fsrc('<?=$pv[$i];?>')">
                </div>
<?php endfor; ?>
              </div>
            </div>
            <div class="col-12 col-sm-6">
              <h3 class="my-3">La Terminal Punto de Venta para tu Negocio.</h3>
              <p>Conocer como va tu negocio es super importante, este sistema punto de venta pone a tu disposición múltiples reportes que te permitirán tomar mejores decisiones.</p>
              <hr />
              <h3>Estadísticas de ventas</h3>
              <p>Comparativo de ventas vs ganancias</p>
              <p>Con esta gráfica podrás conocer a detalle cuanto vendes por día y cuál es tu margen de ganancias para que descubras si realmente tu negocio está generando utilidades y puedas tomar mejores decisiones.</p>
              <hr />
            </div>
          </div>
        <!-- /.card-body -->
      </div>
      <!-- /.card -->

    </section>
    
    <section class="content">
    
    <div class="row">
      
        <div class="col-sm-4">
          <div class="info-box bg-info">
            <span class="info-box-icon">
              <i class="fas fa-cash-register fa-2x"></i>
            </span>
            <div class="info-box-content">
              <span class="info-box-text"><h4>OnePV</h4></span>            
              <span class="description-block">
                El sistema cuenta con el módulo Caja, el cual permite realizar las ventas de tu mercancía de una manera muy fácil e intuitiva, el cual permite llevar un control, así como la posibilidad de realizar ventas de productos.
                El sistema permite llevar a detalle tus inventarios, el cual se va actualizando de manera automática al realizar compras, ventas, registrar mermas, perdidas de productos, etc.
              </span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>

        <div class="col-sm-4">
          <div class="info-box bg-warning">
            <span class="info-box-icon">
              <i class="fas fa-cloud fa-2x"></i>
            </span>
            <div class="info-box-content">
              <span class="info-box-text"><h4>Nube</h4></span>            
              <span class="description-block">
                 Toda la información se encuentra respaldada en tiempo real con los servicios en Internet, lo que garantiza seguridad, gran velocidad y acceso a toda la información desde cualquier lugar, teniendo la posibilidad de acceder desde donde te encentres a la información de tu negocio para la toma de decisiones.
              </span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
        
        <div class="col-sm-4">
          <div class="info-box bg-success">
            <span class="info-box-icon">
              <i class="fa fa-chart-line fa-2x"></i>
            </span>
            <div class="info-box-content">
              <span class="info-box-text"><h4>Estadísticas</h4></span>            
              <span class="description-block">
                Administra el inventario de tu negocio, compras, ventas todo lo referente a entradas y salidas de inventarios, realiza ventas de tus productos, gran variedad de reportes que ayudan a conocer la situación de su negocio, como lo son ventas, inventarios, ganacias, caducidades, etc.
                Esto nos permite notificarte cuando un producto se encuentra en stock mínimo y de esta forma anticiparte a realizar una nueva compra.
              </span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
        </div>
        
      </div>
      
      
      <div class="row">
          <div class="col-md-8">
            <!-- Widget: user widget style 2 -->
            <div class="card card-widget widget-user-2">
              <!-- Add the bg color to the header using any of the bg-* classes -->
              <div class="widget-user-header bg-gradient-success">
                <div class="widget-user-image">
                  <h2><i class="fas fa-cash-register"></i> ¿Por qué usar nuestro punto de venta?</h2>
                </div>
                <!-- /.widget-user-image -->
              </div>
              <div class="card-footer p-0">
                <ul class="nav flex-column">
                  <li class="nav-item">
                    <i class='fas fa-clipboard-check'></i> Todas las funcionalides disponbiles, cuentas con todas las funcionalidades del sistema.
                  </li>
                  <li class="nav-item">
                    <i class='fas fa-clipboard-check'></i> Seguridad de nuestro sistema se encuentra protegido con certificados de seguridad, nuestras bases de datos se encuentran con respaldos, lo que nos garantiza seguridad en su información.
                  </li>
                  <li class="nav-item">
                    <i class='fas fa-clipboard-check'></i> Fácil manejo, nuestro sistema te permite de una manera muy sencilla gestionar todos los movimientos a tus inventarios.
                  </li>
                  <li class="nav-item">
                    <i class='fas fa-clipboard-check'></i> Versatilidad, con nuestra solución puedes acceder desde una computadora o un teléfono móvil para que no te pierdas de nada.
                  </li>
                  <li class="nav-item">
                    <i class='fas fa-clipboard-check'></i> Mejoras, puedes implementar lo que requieras como cajón de dinero, lector de códigos de barras, impresoras de tickets, si a si lo prefieres.
                  </li>
                </ul>
              </div>
            </div>
            <!-- /.widget-user -->
          </div>
          <!-- /.col -->
          <div class="col-md-4">
            <!-- Widget: user widget style 1 -->
            <div class="card card-widget widget-user">
              <!-- Add the bg color to the header using any of the bg-* classes -->
              <div class="widget-user-header bg-info">
                <h3 class="widget-user-username">Contactame</h3>
                <h5 class="widget-user-desc">WhatsApp</h5>
              </div>
              <div class="widget-user-image">
                <img class="img-circle elevation-2" src="archivos/pv4.png">
              </div>
              <div class="card-footer">
                <div class="row">
                  <div class="col-sm-4 border-right">
                    <div class="description-block">
                      <h5 class="description-header">$67</h5>
                      <span class="description-text">Mes</span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  <!-- /.col -->
                  <div class="col-sm-4 border-right">
                    <div class="description-block">
                      <h5 class="description-header">$400</h5>
                      <span class="description-text">6 meses</span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  <!-- /.col -->
                  <div class="col-sm-4">
                    <div class="description-block">
                      <h5 class="description-header">$800</h5>
                      <span class="description-text">Anuales</span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  <!-- /.col -->
                </div>
                <!-- /.row -->
              </div>
            </div>
            <!-- /.widget-user -->
          </div>
          <!-- /.col -->
        </div>
      
    </section>
    
  </div>
  <!-- /.content-wrapper -->  
  
  <!-- Main Footer -->
  <footer class="main-footer">
    <strong>Copyright &COPY; 2020-<?=date('Y'); ?> <a href="nexcen.com.mx">Informatica NEXCEN</a>.</strong> Todos los derechos reservados.
  </footer>
</div>
<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->

<!-- jQuery -->
<script src="<?=$arbolDirectorio;?>public/plugins/jquery/jquery.min.js"></script>
<!-- PrintArea jQuery Plugin -->
<script src="jquery.PrintArea.js"></script>
<!-- Bootstrap 4 -->
<script src="<?=$arbolDirectorio;?>public/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- Toastr -->
<script src="<?=$arbolDirectorio;?>public/plugins/toastr/toastr.min.js"></script>
<!-- AdminLTE App -->
<script src="<?=$arbolDirectorio;?>public/dist/js/adminlte.min.js"></script>
</body>
</html>
<!--https://linnegocios.com-->