<?php
#Incluímos inicialmente la conexión a la base de datos
require_once "../config/Conexion.php";

class PuntoVentaMod{
  #Variables para nombres generales en el Modelo...
  public $tablaDB = "producto";
  private $caracteres_malos = array("'", '"', '\\', '  ','`');  
  
  public function __construct(){  }
  
  public function buscaCodigo($buscaCodigo){
    $query = "SELECT idproducto, producto, marca, descripcion, cantidad, unidadmedida, existencia, total "
            . "FROM $this->tablaDB "
            . "WHERE id$this->tablaDB LIKE '$buscaCodigo%' "
            . "AND idcontrol = '".$_SESSION['idcontrol']."' "
            . "ORDER BY producto ASC;";
    return ejecutarConsulta($query);
  }
  
  public function buscaCoincidencia($buscaCodigo){
    $query = "SELECT idproducto, producto, marca, descripcion, cantidad, unidadmedida, existencia, total "
            . "FROM $this->tablaDB "
            . "WHERE idcontrol = '".$_SESSION['idcontrol']."' "
            . "AND (marca LIKE '%$buscaCodigo%' "
            . "OR producto LIKE '%$buscaCodigo%' "
            . "OR descripcion LIKE '%$buscaCodigo%' "
            . "OR uso LIKE '%$buscaCodigo%'); ";            
    return ejecutarConsulta($query);
  }
  
  public function agregaPV($idproducto, $usuario){    
    $query = "INSERT INTO `puntoVenta` (`idusuario`, `idcontrol`, `idproducto`) "
            . "VALUES ('$usuario', '".$_SESSION['idcontrol']."', '$idproducto'); ";
    return ejecutarConsulta($query);
  }
  
  public function quitaPV($idpuntoVenta, $usuario){    
    if($idpuntoVenta === 'todo') {
      $idpuntoVenta = NULL;
    }else{
      $idpuntoVenta = " AND `idpuntoVenta` = '$idpuntoVenta' ";
    }
    
    $query = "DELETE FROM `puntoVenta` "
            . "WHERE `idusuario` = '$usuario' "
            . "$idpuntoVenta"
            . ";";            
    return ejecutarConsulta($query);
  }
  
  public function listaPV($usuario){
    $query = "SELECT a.idpuntoVenta, a.idproducto, b.producto, b.marca, b.descripcion, b.cantidad, b.unidadmedida, b.total "
            . "FROM puntoVenta a "
            . "INNER JOIN producto b "
            . "ON a.idproducto = b.idproducto "
            . "WHERE a.idusuario = '$usuario' "
            . "AND b.idcontrol = '".$_SESSION['idcontrol']."' ";
    return ejecutarConsulta($query);
  }
  
  public function ultimoID() {
    $query = "SELECT MAX(idventa) AS idventa "
            . "FROM `venta` "
            . "WHERE `idcontrol` = '".$_SESSION['idcontrol']."' ";
    return ejecutarConsulta($query);
  }
  
  public function agrupaPV($usuario) {
    $query = "SELECT DISTINCT(COUNT(a.idproducto)) AS cantidad, a.idproducto, b.producto, b.subtotal, b.iva, b.total "
            . "FROM puntoVenta a "
            . "INNER JOIN producto b "
            . "ON a.idproducto = b.idproducto "
            . "WHERE a.idusuario = '$usuario' "
            . "AND b.idcontrol = '".$_SESSION['idcontrol']."' "
            . "GROUP BY a.idproducto";    
    return ejecutarConsulta($query);    
  }
  
  public function insertaProductoVenta($idproducto, $idventa, $cantidad, $subtotal, $iva, $total, $descuento) {
    #(150*10)-(((150*10)*15)/100) = $1,275;
    $subtotal = ($subtotal*$cantidad)-((($subtotal*$cantidad)*$descuento)/100);
    $$iva = ($iva*$cantidad)-((($iva*$cantidad)*$descuento)/100);
    $total = ($total*$cantidad)-((($total*$cantidad)*$descuento)/100);
    
    if($descuento === '') $descuento = 'NULL'; 
    $query = "INSERT INTO `producto_venta` (`idventa`, `idproducto`, `idcontrol`, `cantidad`, `subtotal`, `iva`, `total`, `descuento`) "
            . "VALUES ('$idventa', '$idproducto', '".$_SESSION['idcontrol']."', '$cantidad', '$subtotal', '$iva', '$total', $descuento); ";
    return ejecutarConsulta($query);    
  }
  
  public function insertaVentaFinal($idventa, $usuario) {
    $query = "INSERT INTO `venta` (`idventa`, `idusuario`, `idcontrol`, `fecha`, `subtotal`, `iva`, `total`) "
            . "VALUES ('$idventa', '$usuario', '".$_SESSION['idcontrol']."', NOW(), '0', '0', '0'); ";
    return ejecutarConsulta($query);    
  }
  
  public function actualizaVentaFinal($idventa, $usuario, $subtotal, $iva, $total, $td, $ttd, $codaceptacion, $multipago, $descuento) {
    if($td === '') $td = $ttd = $codaceptacion = 'NULL'; 
    else{
      $td = "'$td'";
      $ttd = "'$ttd'";
      $codaceptacion = "'$codaceptacion'";
    }
    if($multipago === '') $multipago='NULL'; else $multipago="'$multipago'";
    if($descuento === '') $descuento='NULL'; else $descuento="'$descuento'";
    
    $query = "UPDATE `venta` "
            . "SET subtotal='$subtotal', iva='$iva', total='$total', td=$td, ttd=$ttd, codaceptacion=$codaceptacion, "
            . "multipago=$multipago, descuento=$descuento "
            . "WHERE `idventa` = '$idventa' "
            . "AND `idcontrol` = '".$_SESSION['idcontrol']."'; ";
        
    $queryR = str_replace($this->caracteres_malos, '', $query);
    $bitacora = "INSERT INTO bitacora (fecha, accion, descripcion, MySQL, recupera, idusuario, idcontrol) "
	    . "VALUES (NOW(), 1, 'Registro de Venta #$idventa por $$total', '$queryR', '', '".$_SESSION['idusuario']."', '".$_SESSION['idcontrol']."'); ";
    ejecutarConsulta($bitacora);    
    return ejecutarConsulta($query);    
  }
  
  public function actualizaProductoCantidad($idproducto, $cantidad) {
    $query = "UPDATE `producto` "
            . "SET `existencia` = (existencia-$cantidad) "
            . "WHERE `idproducto` = '$idproducto' "
            . "AND `idcontrol` = '".$_SESSION['idcontrol']."'; ";
    return ejecutarConsulta($query);
  }
  
  public function cualResurtir($idproducto) {
    $query = "SELECT `idresurtir` "
            . "FROM `resurtir` "
            . "WHERE `idproducto` = '$idproducto' "
            . "AND `existencia` > 0 "
            . "AND `idcontrol` = '".$_SESSION['idcontrol']."' "
            . "ORDER BY DATEDIFF(`caducidad`, NOW()) ASC, `existencia` ASC "
            . "LIMIT 1 ";
    return ejecutarConsulta($query);
  }
  
  public function actualizaResurtir($idresurtir) {    
    $query = "UPDATE `resurtir` "
            . "SET `existencia` = (existencia-1) "
            . "WHERE `idresurtir` = '$idresurtir'; ";
    return ejecutarConsulta($query);
  }
  
  public function AvisoExistencia() {
    $query = "SELECT `idproducto`, `marca`, `producto`, `existenciaminima`, `existencia` "
            . "FROM `producto` "
            . "WHERE `existenciaminima` >= `existencia` "
            . "AND existenciaminima > '0' "
            . "AND `idcontrol` = '".$_SESSION['idcontrol']."'; "; 
    return ejecutarConsulta($query);
  }
  
  public function AvisoCaducidad(){    
    $query = "SELECT a.`existencia`, TIMESTAMPDIFF(DAY, NOW(), a.`caducidad`) AS faltan, b.`producto` "
            . "FROM resurtir a "
            . "INNER JOIN producto b ON a.idproducto = b.idproducto "
            . "WHERE a.existencia > 0 "
            . "AND a.caducidad IS NOT NULL "
            . "AND TIMESTAMPDIFF(DAY, NOW(), a.caducidad) < 183 "
            . "AND a.idcontrol = '".$_SESSION['idcontrol']."' "
            . "AND b.idcontrol = '".$_SESSION['idcontrol']."' "
            . "ORDER BY TIMESTAMPDIFF(DAY, NOW(), a.caducidad) ASC; ";    
    return ejecutarConsulta($query);
  }
  
  public function ProductoMasVendido() {
    $query = "SELECT a.`idproducto`, b.`producto` "
            . "FROM `producto_venta` a "
            . "INNER JOIN `producto` b ON a.`idproducto` = b.`idproducto` "
            . "INNER JOIN `venta` c ON a.`idventa` = c.`idventa` "
            . "WHERE TIMESTAMPDIFF(DAY, c.`fecha`, NOW()) < 30 "
            . "AND a.`idcontrol` = '".$_SESSION['idcontrol']."' "
            . "AND b.`idcontrol` = '".$_SESSION['idcontrol']."' "
            . "AND c.`idcontrol` = '".$_SESSION['idcontrol']."' "
            . "GROUP BY a.`idproducto` "
            . "ORDER BY COUNT(a.`idproducto`) DESC "
            . "LIMIT 15;";
    return ejecutarConsulta($query);
  }
  
  #Devoluciones
  public function validaVenta($numVenta) {
    $query = "SELECT `fecha`, `subtotal`, `iva`, `total` "
            . "FROM `venta` "
            . "WHERE `idventa` = '$numVenta' "
            . "AND `idcontrol` = '".$_SESSION['idcontrol']."' "
            . "AND `fecha` BETWEEN DATE_SUB(CURDATE(), INTERVAL 15 DAY) AND CURDATE();";
    return ejecutarConsultaRetornaFila($query);        
  }
  
  public function listaVenta($numVenta) {
    $query = "SELECT a.*, b.producto "
            . "FROM `producto_venta` a "
            . "INNER JOIN `producto` b ON a.`idproducto` = b.`idproducto` "
            . "WHERE a.`idventa` = '$numVenta' "
            . "AND b.`idcontrol` = '".$_SESSION['idcontrol']."' ";
    return ejecutarConsulta($query);        
  }
  
  public function productoSeleccioando($numVenta, $productoSeleccioando) {
    $query = "SELECT a.*, b.producto "
            . "FROM `producto_venta` a "
            . "INNER JOIN `producto` b ON a.`idproducto` = b.`idproducto` "
            . "WHERE a.`idventa` = '$numVenta' "
            . "AND a.`idproducto` = '$productoSeleccioando' "
            . "AND b.`idcontrol` = '".$_SESSION['idcontrol']."' ";
    return ejecutarConsulta($query);        
  }
  #/Devoluciones
  
}
?>