var toastr; //Varible de alertas
var ajaxFile = 'devolucionesAJAX'; //Variable para archivo de ajax.

function iniciar(){
  $('#sectionBuscar').hide();
  $('.pago1').hide();  
  AvisoExistencia();
  AvisoCaducidad();
  ProductoMasVendido();
  limpiarVenta();
  listarPV();
}

$('#tdc').keyup(function(){
  //Validar la entrada de 4 digitos para pago...
  var r = $('#tdc').val();
  if(r.length === 4){
    toastr.info('Indique el código transacción de pago.'); 
  }else{
    $('#btnFinPVprint').prop('disabled', true);
    $('#btnFinPVmaildos').prop('disabled', true);
    if(r.length > 3) toastr.warning('Solo ultimos 4 digitos de la tarjeta.');    
  }  
});

$('#codaceptacion').keyup(function(){
  var r = $('#codaceptacion').val();
  var e = $('#tdc').val();
  
  if(e.length !== 4){
    toastr.warning('Solo ultimos 4 digitos de la tarjeta.');
    $('#tdc').focus();
  }   
  
  if(r.length >= 4 && r.length <= 8){
    $('#btnFinPVprint').prop('disabled', false);
    $('#btnFinPVmaildos').prop('disabled', false);
  }else{
    $('#btnFinPVprint').prop('disabled', true);
    $('#btnFinPVmaildos').prop('disabled', true);
  }
});

$('#multipago').keyup(function(){
  //Validar la entrada de multipago
  var r = $('#multipago').val();
  if(r.length > 20){
    $('#btnFinPVprint').prop('disabled', false);
    $('#btnFinPVmaildos').prop('disabled', false);
  }else{
    $('#btnFinPVprint').prop('disabled', true);
    $('#btnFinPVmaildos').prop('disabled', true);
  }  
});

$('#CobrarVenta').click(function(){
  var TotalModal = $('#TotalModal').val();    
  listarPV();
  $('#confirmaVenta').modal('show');
  $('#EfectivoModal').val(null);
  $('#vueltoModal').html('Cambio');
  limpiarAreaCobro();
  setTimeout(function (){ $('#EfectivoModal').focus(); }, 999);
  
  //Validar si el valor es negativo (No hay devoluciones de dinero)
  if(Math.sign(TotalModal) == '-1'){
    toastr.info('No hay devoluciones de dinero.');
    $('#vueltoModal').html('$0.00');
    $('#btnFinPVprint').prop('disabled', false);
    $('#btnFinPVmaildos').prop('disabled', false);
    $('.pago2').hide( "slow" ); //Salida
    $('.pago1').hide( "slow" ); //Salida    
    $('.pago0').hide('slow'); //Entrada
    $('#tipoPagoSeleccion').hide();
    $('#avisoNoDevoluciones').show();
  }else{
    toastr.warning('Se requiere pago.');
    $('.pago2').hide( "slow" ); //Salida
    $('.pago1').hide( "slow" ); //Salida    
    $('.pago0').slideDown('slow'); //Entrada
    $('#tipoPagoSeleccion').show();
    $('#avisoNoDevoluciones').hide();
  }
});

$('#buscaCodigo').keyup(function(){
  var buscaCodigo = $('#buscaCodigo').val();  
  $("#norepite").val(buscaCodigo);
  
  if(buscaCodigo.length > 1){
    FbuscarCodigo(buscaCodigo);
  }else{
    $('#sectionBuscar').fadeOut(2000);
  }
});

$('#limpiarVenta').click(function(){
  limpiarVenta();
});

function limpiarVenta(){
  //console.log('limpiarVenta');
  toastr.info('<i class="fa fa-cog fa-spin fa-3x fa-fw margin-bottom"></i> T r a b a j a n d o . . .');
  var jqxhr = $.post(ajaxFile+ ".php?op=limpiarPV", function (r){
    //console.log(r);
  })
  .done(function() {
    $("#puntoVenta").html(null); //Limpia
    $('.numerodeproductos').html('0'); //numero productos
    $('.NetoTotal').html('0'); //Total neto
    $('#valNetoTotal').val(null);
    toastr.warning('El punto de venta para devolucion fue limpiado...');
  })
  .fail(function() {
    toastr.error('jQuery limpiarVenta . . .');
  });
  
  $('#sectionMostrarVenta').hide( "slow" ); //Salida
  $('#sectionListaProductos').hide( "slow" ); //Salida
  $('#buscaCodigo').hide();
  $('#btnBuscarProducto').hide();
  $('#numeroVenta').focus();
}

$('#EfectivoModal').keyup(function(){
  //PARA CALCULAR EL CAMBIO SEGUN TOTAL
  var TotalModal = $('#TotalModal').val();  
  var EfectivoModal = $('#EfectivoModal').val();
  var vueltoModal = 0;
  
  vueltoModal = (EfectivoModal - TotalModal).toFixed(2);
    
  if(vueltoModal>=0){
    vueltoModal = '$'+vueltoModal;
    $('#vueltoModal').html(vueltoModal);
    toastr.success('Correcto Efectivo($'+EfectivoModal+') Cambio('+vueltoModal+')');
    $('#btnFinPVprint').prop('disabled', false);
    $('#btnFinPVmaildos').prop('disabled', false);
  }else{
    toastr.warning('Faltan $'+(TotalModal - EfectivoModal).toFixed(2));
    $('#vueltoModal').html('Faltan $'+(vueltoModal*-1));
    $('#btnFinPVprint').prop('disabled', true);
    $('#btnFinPVmaildos').prop('disabled', true);    
  }
});

$("input[type='radio'][name='pago']").change(function(){
  var tp = $("input[type='radio'][name='pago']:checked").val();
  
  $('#btnFinPVprint').prop('disabled', true);
  $('#btnFinPVmaildos').prop('disabled', true);
  
  if(tp === '0'){
    $('#mailTipopago').html('Pago en Efectivo.');
    $('.pago2').hide( "slow" ); //Salida
    $('.pago1').hide( "slow" ); //Salida    
    $('.pago0').slideDown('slow'); //Entrada
    $('#EfectivoModal').focus();
  }
  if(tp === '1'){
    $('#mailTipopago').html('Pago con tarjeta.');
    $('.pago2').hide( "slow" ); //Salida
    $('.pago0').hide( "slow" ); //Salida    
    $('.pago1').slideDown('slow'); //Entrada
    $('#tdc').focus();
  }
  if(tp === '2'){ //Multipago
    $('#mailTipopago').html('Multi pago.');
    $('.pago0').hide( "slow" ); //Salida
    $('.pago1').hide( "slow" ); //Salida    
    $('.pago2').slideDown('slow'); //Entrada
    $('#multipago').focus();
  }
  
  $('#EfectivoModal').val(null);
  $('#vueltoModal').html(null);
  $('#tdc').val(null);
  $('#codaceptacion').val(null);
  $('#multipago').val(null);
});

$('#btnFinPVprint').click(function(){
  var descuento = $('#descuento').val();
  var efectivo = $('#EfectivoModal').val();
  var tdc = $('#tdc').val();
  var ttdc = $("input[type='radio'][name='ttdc']:checked").val();
  var codaceptacion = $('#codaceptacion').val();
  var multipago = $('#multipago').val();
  var numeroVenta = $('#numeroVenta').val(); //Numero de venta a UPDATE.
  var valNetoTotal = $('#valNetoTotal').val(); //Monto a pagar.
  
  var jqxhr = $.post(ajaxFile+ ".php?op=FinPuntoVenta",
  {efectivo:efectivo, tdc:tdc, ttdc:ttdc, codaceptacion:codaceptacion, multipago:multipago, descuento:descuento, numeroVenta:numeroVenta, valNetoTotal:valNetoTotal},
  function(r){
    //console.log(r);
    //toastr.info('<i class="fa fa-cog fa-spin fa-3x fa-fw margin-bottom"></i> T r a b a j a n d o . . .');
  })
  .done(function(r) {
    $('#divprintableArea').html(r);
    toastr.success('Cambio registrado ...');
    limpiarVenta();
    listarPV();
  })
  .fail(function() {
    toastr.error('jQuery btnFinPVprint . . .');
  });
});

$('#btnPrint').click(function(){
  var mode = 'iframe'; // popup
  var close = mode === "popup";
  var options = { mode : mode, popClose : close}; 
  $("div .printableArea").printArea(options);
  
  $('#modalFinPrint').hide();
});

$('#PruebaImpresion').click(function(){
  var jqxhr = $.post(ajaxFile+ ".php?op=PruebaImpresion",function(r){
    //console.log(r);
    })
    .done(function(r) {
      $('#divPruebaPrint').html(r);
      $('#modalPruebaPrint').modal('show');
    })
    .fail(function() {
      toastr.error('jQuery PruebaImpresion . . .');
    });

    jqxhr.always(function() {
      toastr.success('Listo prueba de impresión...');
    });  
});

$('#btnPrintTest').click(function(){
  var mode = 'iframe'; // popup
  var close = mode === "popup";
  var options = { mode : mode, popClose : close}; 
  $("div .printableAreaTest").printArea(options);
  
  $('#modalPruebaPrint').hide();
});

$('#btnFinPVmail').click(function(){
  var efectivo = $('#EfectivoModal').val();
  var email = $('#email').val();
  var tdc = $('#tdc').val();
  var ttdc = $("input[type='radio'][name='ttdc']:checked").val();
  var codaceptacion = $('#codaceptacion').val();
  var multipago = $('#multipago').val();
  var descuento = $('#descuento').val();
  
  var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
  if (regex.test(email) !== false){
    var jqxhr = $.post(ajaxFile+ ".php?op=FinPuntoVenta",{email:email, efectivo:efectivo, tdc:tdc, ttdc:ttdc, codaceptacion:codaceptacion, multipago:multipago,descuento:descuento}, function(r){
      //toastr.info('<i class="fa fa-cog fa-spin fa-3x fa-fw margin-bottom"></i> T r a b a j a n d o . . .');    
    })
    .done(function() {
      $('#modalFinMail').modal('hide');    
      $('#email').val(null);
      listarPV();
      toastr.success('Correo enviado a '+email);
    })
    .fail(function() {
      toastr.error('jQuery btnFinPVmail . . .');
    });

    jqxhr.always(function() {
      toastr.success('Venta registrada...');
    }); 
  }else{
    toastr.warning('Ingrese un correo valido...');
  }
});

function FbuscarCodigo(buscaCodigo){
  $("#resultadoCodigo").html(null);
  
  if(buscaCodigo.length > 0){
    if(!isNaN(buscaCodigo)){ //Si es Numero...
      var jqxhr = $.post(ajaxFile+ ".php?op=buscaCodigo",{buscaCodigo:buscaCodigo}, function(r){
        //toastr.info('<i class="fa fa-cog fa-spin fa-3x fa-fw margin-bottom"></i> T r a b a j a n d o . . .');
      })
      .done(function(r) {
        var separar = r.split('#L'); //Separa en arreglo Var1,Var2,etc..
        $("#verBusca").html(buscaCodigo +' resultados '+separar[1]+' productos encontrados...');
        //console.log(buscaCodigo+' done '+separar[1]);
        if(separar[1]>1){ //mas de uno listar.
          $('#sectionBuscar').fadeIn(2000);
          //console.log('Listar son mas de 1 ...');
          $('#bcA').removeClass(' collapsed-card');
          $('#bcB').removeClass('fa-plus'); $('#bcB').addClass('fa-minus');
          $("#resultadoCodigo").html(separar[0]);
          
        }else if(separar[1]==='1' && $("#norepite").val() === buscaCodigo ){ //Solo uno agrega...
          //console.log('Agrega directo...');
          addPV(separar[2]);
          $("#norepite").val(null);
          $('#sectionBuscar').fadeOut(1000);
          $("#resultadoCodigo").html(null);
        }   
      })
      .fail(function() {
        toastr.error('jQuery buscaCodigo. . .');
      });      
    }else{ // Si no es numero
      $.post(ajaxFile+ ".php?op=buscaCoincidencia", {buscaCodigo:buscaCodigo}, function(r){
        //console.log(r);
      })
      .done(function(r) {
        $('#sectionBuscar').fadeIn(2000);        
        var separar = r.split('#L'); //Separa en arreglo Var1,Var2,etc..
        $('#bcA').removeClass(' collapsed-card');
        $('#bcB').removeClass('fa-plus'); $('#bcB').addClass('fa-minus');
        $("#resultadoCodigo").html(separar[0]);
        $("#verBusca").html(buscaCodigo +' resultados '+separar[1]+' productos encontrados...');
      })
      .fail(function() {
        toastr.error('jQuery buscaCoincidencia. . .');
      });
    }
  }
}

function addPV(codigo){
  //AGREGA PRODUCTO AL PUNTO DE VENTA PV
  $('#bcA').addClass(' collapsed-card');
  $('#bcB').removeClass('fa-minus');
  $('#bcB').addClass('fa-plus');
  $('#buscaCodigo').val(null);
  $('#resultadoCodigo').html(null);
  $('#sectionBuscar').fadeOut(2000);
  
  
  //$.post(ajaxFile+ ".php?op=agregaPV",{codigo:codigo});
  var jqxhr = $.post(ajaxFile+ ".php?op=agregaPV",{codigo:codigo}, function() {
    //toastr.info('<i class="fa fa-cog fa-spin fa-3x fa-fw margin-bottom"></i> T r a b a j a n d o . . .');
  })
  .done(function() {
    toastr.success('Producto ' +codigo+ ' agregado a la lista . . .');
    listarPV();
  })
  .fail(function() {
    toastr.error('jQuery agregaPV . . .');
  });
}

function quitaPV(idpuntoVenta, codigo){
  limpiarVenta();
//  //QUITA PRODUCTO AL PUNTO DE VENTA
//  var jqxhr = $.post(ajaxFile+ ".php?op=quitaPV",{idpuntoVenta:idpuntoVenta}, function(r){
//    //console.log(r);
//  })
//  .done(function() {
//    listarPV();
//    toastr.info('Producto '+codigo+' fue eliminado de la lista de venta...');
//  })
//  .fail(function() {
//    toastr.error('jQuery quitaPV. . .');
//  });
}

function listarPV(){
  var jqxhr = $.post(ajaxFile+ ".php?op=listaPV", function(r){
    //toastr.info('<i class="fa fa-cog fa-spin fa-2x fa-fw margin-bottom"></i> T r a b a j a n d o . . .');
    //console.log(r);
  })
  .done(function(r) {
    $('#puntoVenta').html(''); //Limpia
    $('#puntoVenta').html(null); //Limpia
    var separar = r.split('#L'); //Separa en arreglo Var1,Var2,etc..
    $('#puntoVenta').append(separar[0]); //html res
    $('.numerodeproductos').html( separar[1] ); //numero productos
    if(Number(separar[1]) > 0){
      $('#CobrarVenta').prop('disabled', false);
    }else{
      $('#CobrarVenta').prop('disabled', true);
    }
    $('.NetoTotal').html( separar[2]); //Total neto
    $('#valNetoTotal').val(separar[2]);
    
    var TotalModal = separar[2].replace('$','');
    TotalModal = TotalModal.replace(',','');
    $('#TotalModal').val(TotalModal); //Total neto
  })
  .fail(function() {
    toastr.error('jQuery listaPV . . .');
  });
  $('#numeroVenta').focus();
}

function limpiarAreaCobro(){
  //Limpiar el punto de venta
  $("input[type='radio'][name='pago'][value='0']").prop("checked", true);
  $('.pago0').show(); //Entrada
  $('.pago1').hide(); //Salida
  $('.pago2').hide(); //Salida
  $('#EfectivoModal').val(null);
  $('#vueltoModal').html(null);
  $('#tdc').val(null);  
  $("input[type='radio'][name='ttdc'][value='0']").prop("checked", true);  
  $('#codaceptacion').val(null);
  $('#multipago').val(null);
  $('#mailTipopago').html('Pago en Efectivo.');
  $('#descuento').val(null);
  $('#btnDescuento').slideDown('slow');
  $('#btnFinPVprint').prop('disabled', true);
  $('#btnFinPVmaildos').prop('disabled', true);
}  

function AvisoExistencia(){
  //console.log('AvisoExistencia');
  var jqxhr = $.post(ajaxFile+ ".php?op=AvisoExistencia", function (r){
    //console.log(r);
  })
  .done(function(r) {
    $("#AvisoExistencia").html(r); //Limpia
  })
  .fail(function() {
    toastr.error('jQuery AvisoExistencia . . .');
  });
}

function AvisoCaducidad(){
  //console.log('AvisoExistencia');
  var jqxhr = $.post(ajaxFile+ ".php?op=AvisoCaducidad", function (r){
    //console.log(r);
  })
  .done(function(r) {
    $("#AvisoCaducidad").html(r); //Limpia
  })
  .fail(function() {
    toastr.error('jQuery AvisoCaducidad . . .');
  });
}

function ProductoMasVendido(){
  //console.log('AvisoExistencia');
  var jqxhr = $.post(ajaxFile+ ".php?op=ProductoMasVendido", function (r){
    //console.log(r);
  })
  .done(function(r) {
    $("#ProductoMasVendido").html(r); //Limpia
  })
  .fail(function() {
    toastr.error('jQuery ProductoMasVendido . . .');
  });
}

function ClicProductoMasVendido(producto){
  $("#norepite").val(producto);
  FbuscarCodigo(producto);
}

//Devoluciones....
$('#modalDevolucionMenu').click(function(){
  $('#modalDevolucion').modal('show');
});

$('#btnBuscarVenta').click(function(){
  var numVenta = $('#numeroVenta').val();
  limpiarVenta();
  var jqxhr = $.post(ajaxFile+ ".php?op=validaVenta",{numVenta:numVenta}, function (r){
    //console.log(r);
  })
  .done(function(r) {
    $('#sectionMostrarVenta').slideDown('slow'); //Salida
    var separar = r.split(','); //Separa en arreglo Var1,Var2,etc..
    if(separar[0] !== 'RangoDias'){
      //console.log('btnBuscarVenta',r);
      listaProductoVenta(numVenta);
      $('#sectionListaProductos').hide('slow'); //Salida
    }else{
      //console.log('Venta '+numVenta+' no existente o fuera de rango.');
      toastr.info('Venta '+numVenta+' no existente o fuera de rango.');
      $("#listaVenta").html('<h1>Venta #'+numVenta+' fuera de rango de '+separar[1]+' dias para cambios o no existe la venta.</h1>');
      $('#buscaCodigo').hide();
    }
  })
  .fail(function(r) {
    toastr.error('jQuery Boton Buscar Venta . . .');
    console.log(r);
  });  
});

function listaProductoVenta(numVenta){
  //console.log(numVenta);
  var jqxhr = $.post(ajaxFile+ ".php?op=listaVenta",{numVenta:numVenta}, function (r){
    //console.log(r);
    $('#listaVenta').html(r);
    $('.noMostrarInicio').slideDown('slow'); //Entrada
  })
  .done(function(r) {
    $("#ProductoMasVendido").html(r); //Limpia
  })
  .fail(function() {
    toastr.error('jQuery Listar productos de Venta . . .');
  });  
}

function productoSeleccioando(id, codigo){
  var cantidadDevolver = $('#cantidadDevolver'+id).val();
  if(cantidadDevolver > 0){
    $('#btnDevolucion'+id).remove();
    addPVdevolucion(id, codigo);
    $('#buscaCodigo').show();
    $('#btnBuscarProducto').show();
    $('#sectionListaProductos').slideDown('slow'); //Entrada
    $('#buscaCodigo').focus();
  }else{
    toastr.error('No a selecionado ninguna cantidad a devolver.');
    $('#cantidadDevolver'+id).addClass('text-warning');
  }  
}

function addPVdevolucion(id, codigo){
  //AGREGA PRODUCTO AL PUNTO DE VENTA PV
  $('#bcA').addClass(' collapsed-card');
  $('#bcB').removeClass('fa-minus');
  $('#bcB').addClass('fa-plus');
  $('#buscaCodigo').val(null);
  $("#resultadoCodigo").html(null);
  $('#sectionBuscar').fadeOut(2000);
  
  var cantidadDevolver = $('#cantidadDevolver'+id).val();
  toastr.info('Cantidad a devolver '+cantidadDevolver);
  //$.post(ajaxFile+ ".php?op=agregaPV",{codigo:codigo});
  var jqxhr = $.post(ajaxFile+ ".php?op=agregaPVdevolucion", 
  {codigo:codigo, cantidadDevolver:cantidadDevolver}, function() {
    //toastr.info('<i class="fa fa-cog fa-spin fa-3x fa-fw margin-bottom"></i> T r a b a j a n d o . . .');
  })
  .done(function() {
    toastr.success('Producto ' +codigo+ ' agregado a la lista . . .');
    listarPV();
  })
  .fail(function() {
    toastr.error('jQuery agregaPV . . .');
  });
}

iniciar();