-- Estructura de tabla para la tabla `bitacora`
ALTER TABLE `bitacora` DROP PRIMARY KEY;
ALTER TABLE `bitacora` ADD `idcontrol` INT NOT NULL AFTER `usuario`;
UPDATE `bitacora` SET idcontrol = 2;
ALTER TABLE `bitacora` CHANGE `usuario` `idusuario` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL; 
ALTER TABLE `bitacora` CHANGE `accion` `accion` TINYINT NOT NULL;
UPDATE `bitacora` SET idusuario = 'elanvitalmed@gmail.com';

-- Estructura de tabla para la tabla `contribuyente`
ALTER TABLE `contribuyente` DROP PRIMARY KEY;
ALTER TABLE `contribuyente` CHANGE `nombre` `nombre` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL;
ALTER TABLE `contribuyente` ADD `correotres` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NULL AFTER `correodos`;
ALTER TABLE `contribuyente` ADD `telefono` CHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NULL AFTER `correotres`;
ALTER TABLE `contribuyente` ADD `telefonodos` CHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NULL AFTER `telefono`;
ALTER TABLE `contribuyente` ADD `telefonotres` CHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NULL AFTER `telefonodos`;

-- Estructura de tabla para la tabla `eventoCalendario`
ALTER TABLE `eventoCalendario` CHANGE `ideventoCalendario` `ideventoCalendario` INT(11) NOT NULL; 
ALTER TABLE `eventoCalendario` DROP PRIMARY KEY;
ALTER TABLE `eventoCalendario` ADD `idusuario` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL AFTER `ideventoCalendario`, ADD `idcontrol` INT NOT NULL AFTER `idusuario`; 
UPDATE `eventoCalendario` SET idusuario = 'elanvitalmed@gmail.com';
UPDATE `eventoCalendario` SET idcontrol = 2;
ALTER TABLE `eventoCalendario` CHANGE `idusuario` `idusuario` VARCHAR(255) CHARACTER SET utf32 COLLATE utf32_unicode_520_ci NOT NULL; 

-- Estructura de tabla para la tabla `producto`
ALTER TABLE `producto` DROP PRIMARY KEY;
ALTER TABLE `producto` ADD `idcontrol` INT NOT NULL AFTER `idproducto`; 
UPDATE `producto` SET idcontrol = 2;
ALTER TABLE `producto` CHANGE `cantidad` `cantidad` SMALLINT(6) NULL; 
ALTER TABLE `producto` CHANGE `compra` `compra` FLOAT(10,2) NOT NULL; 
ALTER TABLE `producto` CHANGE `subtotal` `subtotal` FLOAT(10,2) NOT NULL; 
ALTER TABLE `producto` CHANGE `iva` `iva` FLOAT(10,2) NOT NULL; 
ALTER TABLE `producto` CHANGE `total` `total` FLOAT(10,2) NOT NULL; 

-- Estructura de tabla para la tabla `producto_venta`
ALTER TABLE `producto_venta` DROP PRIMARY KEY;
ALTER TABLE `producto_venta` ADD `idcontrol` INT NOT NULL AFTER `idproducto`; 
UPDATE `producto_venta` SET idcontrol = 2;
ALTER TABLE `producto_venta` CHANGE `subtotal` `subtotal` FLOAT(10,2) NOT NULL; 
ALTER TABLE `producto_venta` CHANGE `iva` `iva` FLOAT(10,2) NOT NULL; 
ALTER TABLE `producto_venta` CHANGE `total` `total` FLOAT(10,2) NOT NULL;

-- Estructura de tabla para la tabla `puntoVenta`
DROP TABLE `puntoVenta`;
CREATE TABLE `puntoVenta` (
  `idpuntoVenta` int(11) NOT NULL,
  `idusuario` varchar(255) NOT NULL,
  `idcontrol` int(11) NOT NULL,
  `idproducto` char(48) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='			';

-- Estructura de tabla para la tabla `resurtir`
ALTER TABLE `resurtir` CHANGE `idresurtir` `idresurtir` INT(11) NOT NULL; 
ALTER TABLE `resurtir` DROP PRIMARY KEY;
ALTER TABLE `resurtir` CHANGE `idproducto` `idproducto` CHAR(48) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL AFTER `idresurtir`, CHANGE `idcontribuyente` `idcontribuyente` CHAR(13) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL AFTER `idproducto`;
ALTER TABLE `resurtir` ADD `idcontrol` INT NOT NULL AFTER `idproducto`; 
UPDATE `resurtir` SET idcontrol = 2;
ALTER TABLE `resurtir` CHANGE `fecha` `fecha` DATETIME NOT NULL;
ALTER TABLE `resurtir` CHANGE `cantidad` `cantidad` SMALLINT NOT NULL;
ALTER TABLE `resurtir` CHANGE `existencia` `existencia` SMALLINT NOT NULL;
ALTER TABLE `resurtir` CHANGE `compra` `compra` FLOAT(10,2) NOT NULL;
UPDATE resurtir SET idcontribuyente = 'GUMMA' WHERE idcontribuyente = 'GUMMAA';
DELETE FROM `contribuyente` WHERE `idcontribuyente` = 'GUMMAA';

-- Estructura de tabla para la tabla `usuario`
ALTER TABLE `usuario` DROP PRIMARY KEY;
ALTER TABLE `usuario` ADD `idcontrol` INT NOT NULL AFTER `idusuario`; 
UPDATE `usuario` SET idcontrol = 2;
ALTER TABLE `usuario` CHANGE `password` `password` CHAR(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL; 
ALTER TABLE `usuario` CHANGE `estado` `estado` TINYINT NOT NULL; 

-- Estructura de tabla para la tabla `venta`
ALTER TABLE `venta` DROP PRIMARY KEY;
ALTER TABLE `venta` CHANGE `usuario` `idusuario` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL; 
ALTER TABLE `venta` ADD `idcontrol` INT NOT NULL AFTER `idusuario`; 
UPDATE `venta` SET idcontrol = 2;
ALTER TABLE `venta` CHANGE `fecha` `fecha` DATETIME NOT NULL;
ALTER TABLE `venta` CHANGE `subtotal` `subtotal` FLOAT(10,2) NOT NULL; 
ALTER TABLE `venta` CHANGE `iva` `iva` FLOAT(10,2) NOT NULL; 
ALTER TABLE `venta` CHANGE `total` `total` FLOAT(10,2) NOT NULL; 
ALTER TABLE `venta` CHANGE `tdc` `td` SMALLINT(6) NULL DEFAULT NULL;
ALTER TABLE `venta` CHANGE `ttdc` `ttd` tinyint NULL DEFAULT NULL;
ALTER TABLE `venta` CHANGE `idcontribuyente` `idcontribuyente` CHAR(13) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL; 
UPDATE `venta` SET `idusuario` = 'elanvitalmed@gmail.com';

-- Estructura de tabla para la tabla `control`
CREATE TABLE `control` (
  `idcontrol` int(11) NOT NULL,
  `usuario` varchar(255) NOT NULL,
  `registro` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `control` (`idcontrol`, `usuario`, `registro`) 
VALUES ('1', 'emiliovm@nexcen.com.mx', NOW()), ('2', 'elanvitalmed@gmail.com', NOW());
  
# Acciones del creacion de DB evmPHPpoo
-- Indices de la tabla `bitacora`
ALTER TABLE `bitacora`
  ADD PRIMARY KEY (`fecha`),
  ADD KEY `fk_bitacora_usuario1_idx` (`idusuario`,`idcontrol`);

--
-- Indices de la tabla `contribuyente`
--
ALTER TABLE `contribuyente`
  ADD PRIMARY KEY (`idcontribuyente`);

--
-- Indices de la tabla `control`
--
ALTER TABLE `control`
  ADD PRIMARY KEY (`idcontrol`);

--
-- Indices de la tabla `eventoCalendario`
--
ALTER TABLE `eventoCalendario`
  ADD PRIMARY KEY (`ideventoCalendario`),
  ADD KEY `fk_eventoCalendario_usuario1_idx` (`idusuario`,`idcontrol`);

--
-- Indices de la tabla `producto`
--
ALTER TABLE `producto`
  ADD PRIMARY KEY (`idproducto`,`idcontrol`),
  ADD KEY `fk_producto_control1_idx` (`idcontrol`);

--
-- Indices de la tabla `producto_venta`
--
ALTER TABLE `producto_venta`
  ADD PRIMARY KEY (`idventa`,`idproducto`,`idcontrol`),
  ADD KEY `fk_producto_has_venta_venta1_idx` (`idventa`),
  ADD KEY `fk_producto_has_venta_producto1_idx` (`idproducto`,`idcontrol`);

--
-- Indices de la tabla `puntoVenta`
--
ALTER TABLE `puntoVenta`
  ADD PRIMARY KEY (`idpuntoVenta`),
  ADD KEY `fk_puntoVenta_usuario1_idx` (`idusuario`,`idcontrol`),
  ADD KEY `fk_puntoVenta_producto1_idx` (`idproducto`);

--
-- Indices de la tabla `resurtir`
--
ALTER TABLE `resurtir`
  ADD PRIMARY KEY (`idresurtir`),
  ADD KEY `fk_resurtir_producto1_idx` (`idproducto`,`idcontrol`),
  ADD KEY `fk_resurtir_contribuyente1_idx` (`idcontribuyente`);

--
-- Indices de la tabla `usuario`
--
ALTER TABLE `usuario`
  ADD PRIMARY KEY (`idusuario`,`idcontrol`),
  ADD KEY `fk_usuario_control_idx` (`idcontrol`);

--
-- Indices de la tabla `venta`
--
ALTER TABLE `venta`
  ADD PRIMARY KEY (`idventa`),
  ADD KEY `fk_venta_usuario1_idx` (`idusuario`,`idcontrol`),
  ADD KEY `fk_venta_contribuyente1_idx` (`idcontribuyente`);

--
-- AUTO_INCREMENT de la tabla `control`
--
ALTER TABLE `control`
  MODIFY `idcontrol` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `puntoVenta`
--
ALTER TABLE `puntoVenta`
  MODIFY `idpuntoVenta` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `resurtir`
--
ALTER TABLE `resurtir`
  MODIFY `idresurtir` int(11) NOT NULL AUTO_INCREMENT;

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `bitacora`
--
ALTER TABLE `bitacora`
  ADD CONSTRAINT `fk_bitacora_usuario1` FOREIGN KEY (`idusuario`,`idcontrol`) REFERENCES `usuario` (`idusuario`, `idcontrol`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Filtros para la tabla `eventoCalendario`
--

ALTER TABLE `eventoCalendario`
  ADD CONSTRAINT `fk_eventoCalendario_usuario1` FOREIGN KEY (`idusuario`,`idcontrol`) REFERENCES `usuario` (`idusuario`, `idcontrol`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Filtros para la tabla `producto`
--
ALTER TABLE `producto`
  ADD CONSTRAINT `fk_producto_control1` FOREIGN KEY (`idcontrol`) REFERENCES `control` (`idcontrol`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Filtros para la tabla `producto_venta`
--
ALTER TABLE `producto_venta`
  ADD CONSTRAINT `fk_producto_has_venta_producto1` FOREIGN KEY (`idproducto`,`idcontrol`) REFERENCES `producto` (`idproducto`, `idcontrol`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_producto_has_venta_venta1` FOREIGN KEY (`idventa`) REFERENCES `venta` (`idventa`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Filtros para la tabla `puntoVenta`
--
/*
ALTER TABLE `puntoVenta`
  ADD CONSTRAINT `fk_puntoVenta_producto1` FOREIGN KEY (`idproducto`) REFERENCES `producto` (`idproducto`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_puntoVenta_usuario1` FOREIGN KEY (`idusuario`,`idcontrol`) REFERENCES `usuario` (`idusuario`, `idcontrol`) ON DELETE NO ACTION ON UPDATE NO ACTION;
*/

--
-- Filtros para la tabla `resurtir`
--
ALTER TABLE `resurtir`
  ADD CONSTRAINT `fk_resurtir_contribuyente1` FOREIGN KEY (`idcontribuyente`) REFERENCES `contribuyente` (`idcontribuyente`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_resurtir_producto1` FOREIGN KEY (`idproducto`,`idcontrol`) REFERENCES `producto` (`idproducto`, `idcontrol`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Filtros para la tabla `usuario`
--
ALTER TABLE `usuario`
  ADD CONSTRAINT `fk_usuario_control` FOREIGN KEY (`idcontrol`) REFERENCES `control` (`idcontrol`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Filtros para la tabla `venta`
--
ALTER TABLE `venta`
  ADD CONSTRAINT `fk_venta_contribuyente1` FOREIGN KEY (`idcontribuyente`) REFERENCES `contribuyente` (`idcontribuyente`) ON DELETE NO ACTION ON UPDATE NO ACTION;