<?php 
require ("../modelos/BuscaVenta.php");
require ("../modelos/Control.php");
require ('../config/funcion.php');

$ruta = 'ajax/'. filter_input(INPUT_SERVER, 'REQUEST_URI', FILTER_SANITIZE_URL); #Regresa el nombre del archivo actual

$classBuscar = new BuscaVenta();
$classControl = new Control();
$TituloP = 'Buscar';

foreach($_POST as $campo => $valor) {
    $_POST[$campo] = filter_input(INPUT_POST, $campo, FILTER_SANITIZE_STRING);
}
extract($_POST);

$caracteres_malos = array(' ', "'", '"', '(', ')', '<', '>', '\\', '/', '!', '¡', '#', '$', '%', '&', '=', '¿','?', '|');

$fecha = Fverfecha(5);

switch (GET('op')) {
  
  case 'solicitarFactura':
    $rfc = strtoupper(trim($rfc));
    $rfc = str_replace($caracteres_malos, '', $rfc);    
    $nombreContribuyente = strtoupper(trim($nombre));
    $direccion = trim($direccion);
    $email = trim($mfemail);
    $email2 = trim($mfemail2);
    
    if($existerfc === ''){ #Para Ingresar datos nuevos ya que no hay idPrincipal.
      $classBuscar->insertarContribuyente($rfc, $nombreContribuyente, $direccion, $email, $email2);
    }else{ #Si existe idPrincipal edita el registro.
      $classBuscar->editarContribuyente($existerfc, $rfc, $nombreContribuyente, $direccion, $email, $email2);
    }
    $resultado = $classBuscar->solicitaFacturaVenta($idventa, $rfc, $usocfdi);
    #Estructura Tipo de alerta despues texto (success,TextoAmostrar)
    echo $resultado ? "success,Solicitud de factura enviada para venta $idventa." : "error,Solicitud de factura no enviada para venta $idventa.<br />Reporta: $ruta $compra";
    break;
  
  case 'Buscar':
    $control = GET('c');
    $fechainicio = GET('fi');
    $fechafin = GET('ff');
    
    $row = $classBuscar->Buscar($control, $fechainicio, $fechafin);
    $data = array();
    
    while ($rowX = $row->fetch_object() ) {
      #Inicialisado varibles      
      $eventos = '<button type="button" class="btn btn-outline-primary" onclick="listaEventos('.$rowX->idventa.'); window.open(\'#divEventos\',\'_parent\');" title="Motrar Desgloce de Venta '.$rowX->idventa.'">'
              . '<i class="fas fa-dollar-sign"></i>&nbsp;<i class="fas fa-sort-amount-down"></i>'
              . '</button> '
              . '<button type="button" class="btn btn-outline-info" onclick="mailVenta('.$rowX->idventa.');" title="Mandar por correo '.$rowX->idventa.'">'
              . '<i class="fas fa-envelope"></i>&nbsp;<i class="far fa-paper-plane"></i>'
              . '</button> ';
      if($rowX->estado === null and $rowX->mesf === '0'){
        $eventos .= '<button type="button" class="btn btn-outline-warning" onclick="facturaVenta('.$rowX->idventa.');" title="Solicitar Factura de venta '.$rowX->idventa.'">'
              . '<i class="fas fa-file-invoice-dollar"></i>&nbsp;<i class="fas fa-level-up-alt"></i>'
              . '</button> ';
      }else{
        if($rowX->estado === '0'){ $estado = '<span class="badge bg-gray">Pendiente de Facturar</span>'; }
      if($rowX->estado === '1'){ $estado = '<span class="badge bg-success">Facturarado</span>'; }
      }
      
      $TipoPago = 'Efectivo';
      if($rowX->td != ''){
        switch($rowX->ttd) {
          case '0': $TipoPago = "Debito VISA $rowX->td CAB:$rowX->codaceptacion"; break;
          case '1': $TipoPago = "Debito MC $rowX->td CAB:$rowX->codaceptacion"; break;
          case '2': $TipoPago = "Debito AE $rowX->td CAB:$rowX->codaceptacion"; break;
          case '3': $TipoPago = "Credito VISA $rowX->td CAB:$rowX->codaceptacion"; break;
          case '4': $TipoPago = "Credito MC $rowX->td CAB:$rowX->codaceptacion"; break;
          case '5': $TipoPago = "Credito AE $rowX->td CAB:$rowX->codaceptacion"; break;
        }
      }
      ($rowX->multipago != '') ? $TipoPago = "Multipago: $rowX->multipago" : NULL;
      ($rowX->descuento != '') ? $descuento = $rowX->descuento.'%' : $descuento = NULL;
            
      $data[] = array(          
          '0' => $rowX->idventa,
          '1' => $rowX->fecha,
          '2' => $TipoPago,
          '3' => $descuento,
          '4' => $rowX->subtotal,
          '5' => $rowX->iva,
          '6' => $rowX->total,
          '7' => $rowX->nombre,
          '8' => $estado,
          '9' => $eventos              
      );
    }
    unset($row,$rowX);

    $row = array(
	"sEcho" => 1, #Informacion para el datatables.
	"iTotalRecords" =>count($data), #Envia el totoal de registros al datatable.
	"iTotalDisplayRecords"=> count($data), #Total de registros a visualizar.
	"aaData"=>$data # Envia el array con todos los registros.               
	);
    echo json_encode($row);
    break;
  
  case 'listaEventos':
    $html = NULL;
    $idRegistro = GET('id');
    $row = $classBuscar->listaEventos($idRegistro);
    
    while ($rowX = $row->fetch_object() ) {
      $html .= '<tr class="listaEventos">
                  <td>'.$rowX->idproducto.'</td>
                  <td>'.$rowX->codigosat.'</td>
                  <td>'.$rowX->marca.' '.$rowX->producto.'</td>
                  <td>'.$rowX->cantidad.'</td>
                  <td aling="rigth">'.Fmoneda($rowX->subtotal,1).'</td>
                  <td aling="rigth">'.Fmoneda($rowX->iva,1).'</td>
                  <td aling="rigth">'.Fmoneda($rowX->total,1).'</td>
                </tr>';
      $fecha = $rowX->fecha;
      $nombre = $rowX->nombre;
      
      $TipoPago = 'Pago en Efectivo';
      if($rowX->td != ''){
        switch($rowX->ttd) {
          case '0': $TipoPago = "Pago Debito VISA $rowX->td CAB:$rowX->codaceptacion"; break;
          case '1': $TipoPago = "Pago Debito MC $rowX->td CAB:$rowX->codaceptacion"; break;
          case '2': $TipoPago = "Pago Debito AE $rowX->td CAB:$rowX->codaceptacion"; break;
          case '3': $TipoPago = "Pago Credito VISA $rowX->td CAB:$rowX->codaceptacion"; break;
          case '4': $TipoPago = "Pago Credito MC $rowX->td CAB:$rowX->codaceptacion"; break;
          case '5': $TipoPago = "Pago Credito AE $rowX->td CAB:$rowX->codaceptacion"; break;
        }
      }
      if($rowX->multipago != ''){
        $TipoPago = "Multi Pago: $rowX->multipago";
      }
      $total = 'Total: '.Fmoneda($rowX->ventatotal, 1);
      if($rowX->descuento != ''){ $descuento = "Descuento: $rowX->descuento%"; }
    }
    unset($row,$rowX);
    
    echo "$html#R".Ffechahora($fecha, 1)."#R$nombre#R$TipoPago#R$descuento $total-";
    break;
    
  case 'VentaMail':
    $row = $classBuscar->listaEventos($venta);    
    
    while ($rowX = $row->fetch_object() ) {
      $tbody .= '<tr>
                  <th>'.$rowX->idproducto.'</th>
                  <td>'.$rowX->marca.' '.$rowX->producto.'</td>
                  <td align="center">'.$rowX->cantidad.'</td>
                  <td aling="rigth">'.Fmoneda($rowX->subtotal,1).'</td>
                  <td aling="rigth">'.Fmoneda($rowX->iva,1).'</td>
                  <td aling="rigth">'.Fmoneda($rowX->total,1).'</td>
                </tr>';
      $fecha = $rowX->fecha;
      
      $TipoPago = 'Pago en Efectivo';
      if($rowX->td != ''){
        switch($rowX->ttd) {
          case '0': $TipoPago = "Pago Debito VISA $rowX->td CAB:$rowX->codaceptacion"; break;
          case '1': $TipoPago = "Pago Debito MC $rowX->td CAB:$rowX->codaceptacion"; break;
          case '2': $TipoPago = "Pago Debito AE $rowX->td CAB:$rowX->codaceptacion"; break;
          case '3': $TipoPago = "Pago Credito VISA $rowX->td CAB:$rowX->codaceptacion"; break;
          case '4': $TipoPago = "Pago Credito MC $rowX->td CAB:$rowX->codaceptacion"; break;
          case '5': $TipoPago = "Pago Credito AE $rowX->td CAB:$rowX->codaceptacion"; break;
        }
      }
      if($rowX->multipago != ''){
        $TipoPago = "Multi Pago: $rowX->multipago";
      }
      $total = 'Total: '.Fmoneda($rowX->ventatotal, 1);
      $descuento = null;
      if($rowX->descuento != ''){ $descuento = "Descuento del $rowX->descuento%"; }
      
      #Operaciones para la venta total...
      $Acumulasubtotal += $rowX->subtotal;
      $Acumulaiva += $rowX->iva;
      $Acumulatotal += $rowX->total;
    }
    
    if($descuento !== ''){      
      $Acumulasubtotal = $Acumulasubtotal - (($Acumulasubtotal * $descuento) / 100);
      $Acumulaiva = $Acumulaiva - (($Acumulaiva * $descuento) / 100);
      $Acumulatotal = $Acumulatotal - (($Acumulatotal * $descuento) / 100);
    }
    
    $formato = explode('_._', $classControl->campoControl('formatoticket')); #Obten fomato de ticket
    
    $logo = $classControl->campoControl('logoext'); #La estencon para la imagen Lx.$ext
    
    if($logo !== NULL){
      $logo = '<img class="img-fluid" src="../imagenes/L'.$_SESSION['idcontrol'].'.'.$logo.'" style="max-width: '.$formato[0].'px; max-height: '.$formato[0].'px;">';
    } else {
      $logo = '<i class="fas fa-print fa-3x"></i>';
    }
    
    $mensaje = '<!doctype html>
<html>
  <head>
    <meta charset="utf-8">
      <style type="text/css">
table{
	font-family:Verdana, Geneva, sans-serif;
}
svg{
	height: 60px;
	width: auto;
}
      </style>
</head>

<body>
  <table border="0" align="center" cellpadding="2" cellspacing="2">
    <thead>
      <tr>
        <th colspan="6" align="center"><path fill="currentColor" d="M476 3.2L12.5 270.6c-18.1 10.4-15.8 35.6 2.2 43.2L121 358.4l287.3-253.2c5.5-4.9 13.3 2.6 8.6 8.3L176 407v80.5c0 23.6 28.5 32.9 42.5 15.8L282 426l124.6 52.2c14.2 6 30.4-2.9 33-18.2l72-432C515 7.8 493.3-6.8 476 3.2z" class=""></path></th>
      </tr>
      <tr>
        <th colspan="6" align="center">'.$formato[1].'</th>
      </tr>
      <tr>
        <th colspan="6" align="center">'.$formato[2].'</th>
      </tr>
      <tr>
        <th colspan="6" align="center">'.$formato[3].'</th>
      </tr>
      <tr>
        <th colspan="2" align="right">Venta #</th>
        <td colspan="4" align="left">'.$venta.'</td>
      </tr>
      <tr>
        <th colspan="2" align="right">Fecha de Compra:</th>
        <td colspan="4" align="left">'.Ffechahora($fecha, true).'</td>
      </tr>
      <tr>
        <th colspan="6" scope="col"><hr></th>
        </tr>
      <tr>
        <th scope="col">Clave Producto</th>
        <th scope="col">Producto</th>
        <th scope="col">Cantidad</th>
        <th scope="col">SubTotal</th>
        <th scope="col">IVA</th>
        <th scope="col">Total</th>
      </tr>
    </thead>
    <tbody>  
      '.$tbody.'
    </tbody>
    <tfoot>
	<tr>
  	<th colspan="6" align="right">&nbsp;'.$descuento.'</th>
	  </tr>
	<tr>
	  <th>Forma de Pago:</th>
	  <td>&nbsp;</td>
	  <th>&nbsp;</th>
	  <th colspan="2" align="right">SubTotal:</th>
	  <td align="right">'. Fmoneda($Acumulasubtotal, true).'</td>
	  </tr>
	<tr>
	  <td colspan="3" rowspan="2" align="center" bgcolor="#EBEBEB">'.$TipoPago.'</td>
	  <th colspan="2" align="right">IVA:</th>
	  <td align="right">'.Fmoneda($Acumulaiva, true).'</td>
	  </tr>
	<tr>
	  <th colspan="2" align="right">Total:</th>
	  <td align="right">'.Fmoneda($Acumulasubtotal, true).'</td>
	  </tr>
        <tr>
          <th colspan="6" align="center">'.$formato[4].'</th>
        </tr>
        <tr>
          <th colspan="6" align="center">'.$formato[5].'</th>
        </tr>
        <tr>
          <th colspan="6" align="center">'.$formato[6].'</th>
        </tr>
	<tr>
	  <th colspan="6" align="center"><svg aria-hidden="true" focusable="false" data-prefix="fas" data-icon="envelope-open-text" role="img" viewBox="0 0 512 512" class="svg-inline--fa fa-envelope-open-text fa-w-16 fa-2x"><path fill="currentColor" d="M176 216h160c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16H176c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16zm-16 80c0 8.84 7.16 16 16 16h160c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16H176c-8.84 0-16 7.16-16 16v16zm96 121.13c-16.42 0-32.84-5.06-46.86-15.19L0 250.86V464c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V250.86L302.86 401.94c-14.02 10.12-30.44 15.19-46.86 15.19zm237.61-254.18c-8.85-6.94-17.24-13.47-29.61-22.81V96c0-26.51-21.49-48-48-48h-77.55c-3.04-2.2-5.87-4.26-9.04-6.56C312.6 29.17 279.2-.35 256 0c-23.2-.35-56.59 29.17-73.41 41.44-3.17 2.3-6 4.36-9.04 6.56H96c-26.51 0-48 21.49-48 48v44.14c-12.37 9.33-20.76 15.87-29.61 22.81A47.995 47.995 0 0 0 0 200.72v10.65l96 69.35V96h320v184.72l96-69.35v-10.65c0-14.74-6.78-28.67-18.39-37.77z" class=""></path></svg></th>
	</tr>
      </tfoot>  
    </table>
  </body>
</html>
';     
    $server = filter_input(INPUT_SERVER, 'HTTP_HOST', FILTER_SANITIZE_URL);
    
    #El From = de
    $para = 'Cliente Farmacia <'.$email.'>'."\r\n";
    $para .= "\r\n";

    $titulo = 'Tu eTicket #'.$venta;
    $de = 'ciepv@'.$server."\r\n";

    $cabeceras .= "From: $de";
    $cabeceras .= 'X-Mailer: PHP/'.phpversion()."\r\n";
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
    $cabeceras .= 'MIME-Version: 1.0'."\r\n";
    $cabeceras .= 'Content-type: text/html; charset=UTF-8'."\r\n";

    #echo $mensaje; 
    mail( $para , $titulo , $mensaje , $cabeceras );    
    unset( $para , $titulo , $mensaje , $cabeceras, $row, $rowX);
    break;
    
  case 'validaRFC':
    $rfc = str_replace($caracteres_malos, '', $rfc);
    $rfc = strtoupper(trim($rfc));
    
    $row = $classBuscar->validaRFC($rfc);
    if ($row->num_rows > 1){
      while ($rowX = $row->fetch_object()){
        $resultado .= '<option label="'.$rowX->idcontribuyente.'">'.$rowX->idcontribuyente.'</option>';
      }
      $resultado = "2#$resultado";
    }elseif ($row->num_rows === 1){
      $rowX = $row->fetch_object();
      $resultado = "1#$rowX->idcontribuyente#$rowX->nombre#$rowX->direccion#$rowX->correo#$rowX->correodos";
    }else {
      $resultado = "0#";
    }
    
    echo $resultado;
    break;
    
  default:
    echo "LD. $host$rutaFile";
}
?>