<?php 
require ("../modelos/ReporteHoraVenta.php");
require ('../config/funcion.php');

$ruta = 'ajax/'. filter_input(INPUT_SERVER, 'REQUEST_URI', FILTER_SANITIZE_URL); #Regresa el nombre del archivo actual

$classRHV = new ReporteHoraVenta();
$TituloP = 'Buscar';

foreach($_POST as $campo => $valor) {
    $_POST[$campo] = filter_input(INPUT_POST, $campo, FILTER_SANITIZE_STRING);
}
extract($_POST);

$fecha = Fverfecha(5);

switch (GET('op')) {
  case 'listaEventos':
    $tbody = $AcumulaTD = $AcumulaMP = $AcumulaE = $Acumulado = NULL;
    $row = $classRHV->listaEventos($uValor, $fi, $ff, $hi,$hf);
    
    while ($rowX = $row->fetch_object() ) {
      
      if($rowX->td != ''){
        switch($rowX->ttd) {
          case '0': $TipoPago = "Pago Debito VISA $rowX->td CAB:$rowX->codaceptacion"; break;
          case '1': $TipoPago = "Pago Debito MC $rowX->td CAB:$rowX->codaceptacion"; break;
          case '2': $TipoPago = "Pago Debito AE $rowX->td CAB:$rowX->codaceptacion"; break;
          case '3': $TipoPago = "Pago Credito VISA $rowX->td CAB:$rowX->codaceptacion"; break;
          case '4': $TipoPago = "Pago Credito MC $rowX->td CAB:$rowX->codaceptacion"; break;
          case '5': $TipoPago = "Pago Credito AE $rowX->td CAB:$rowX->codaceptacion"; break;
        }
        $AcumulaTD += $rowX->total;
      } else if($rowX->multipago != ''){
        $TipoPago = 'Multi Pago: '.nl2br($rowX->multipago);
        $AcumulaMP += $rowX->total;
      }else{
        $TipoPago = 'Pago en Efectivo';
        $AcumulaE += $rowX->total;
      }
      $Acumulado += $rowX->total;
      
      is_numeric($rowX->descuento) ? $descuento = "$rowX->descuento%" : $descuento = NULL;
      
      $tbody .= '<tr class="listaEventos">
                  <td>'.$rowX->idventa.'</td>
                  <td>'.$rowX->nombre.'</td>
                  <td>'.$rowX->fecha.'</td>
                  <td class="text-center">'.$descuento.'</td>
                  <td aling="rigth" class="text-right">'.Fmoneda($rowX->subtotal,1).'</td>
                  <td aling="rigth" class="text-right">'.Fmoneda($rowX->iva,1).'</td>
                  <td aling="rigth" class="text-right">'.Fmoneda($rowX->total,1).'</td>
                  <td>'.$TipoPago.'</td>
                </tr>';
    }
    
    $tbody .= '<tr class="listaEventos text-success">'
            . '<td colspan="7" class="text-right">Total Acumulado en Efectivo:</td>'
            . '<td class="text-right">'. Fmoneda($AcumulaE, true).' -</td>'
            . '</tr>'
            . '<tr class="listaEventos text-info">'
            . '<td colspan="7" class="text-right">Total Acumulado Pago con Tarjeta:</td>'
            . '<td class="text-right">'. Fmoneda($AcumulaTD, true).' -</td>'
            . '</tr>'
            . '<tr class="listaEventos text-teal">'
            . '<td colspan="7" class="text-right">Total Acumulado Multi Pagos:</td>'
            . '<td class="text-right">'. Fmoneda($AcumulaMP, true).' -</td>'
            . '</tr>'
            . '<tr class="listaEventos text-primary">'
            . '<td colspan="7" class="text-right">Total Acumulado de todas las ventas:</td>'
            . '<td class="text-right">'. Fmoneda($Acumulado, true).' -</td>'
            . '</tr>';
    unset($row,$rowX);
    
    echo "$tbody#R".Ffechahora($fi, 1);
    break;
    
  case 'listaUsuario':
    $option = '<option selected="selected" value="Todos">Todos los Usuarios</option>';
    $row = $classRHV->listaUsuario();
      
    while ($rowX = $row->fetch_object() ) {
      $option .= "<option value=\"$rowX->idusuario\">$rowX->nombre</option>";
    }
    echo $option;
    break;            
  
  default:
    echo "LD. $host$rutaFile";
}
?>