<?PHP require 'header.php'; ?>

<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
<!--            <h1><i class="fas fa-shipping-fast"></i> Registros de Control</h1>-->
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item active">Opciones</li>
              <li class="breadcrumb-item"><a href="#" onclick="mostrarForm();"><i class="fas fa-plus"></i> Agregar Evento</a></li>
              <li class="breadcrumb-item"><a href="#" id="listarCliente"><i class='fas fa-book'></i> Lista de Clientes</a></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    
    <section id="ListadoClientes" class="content">
      <div class="card">
        <div class="card-header">
          <h3 class="card-title"><i class='fas fa-book'></i> Lista de Clientes.</h3>
          <div class="card-tools">
            <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fas fa-minus"></i>
            </button>                
          </div>
        </div>
        <div class="card-body" style="display: block;">
            <div class="row">
              <table class="table table-striped">            
                <thead>
                  <tr class="text-blue">
                    <th>Fecha</th>
                    <th>Titulo</th>
                    <th>Telefono</th>
                    <th>Correo</th>
                    <th>-</th>
                  </tr>
                </thead>
                <tbody id="listaClientes">
                </tbody>
              </table>
            </div>

        </div>
        <!-- /.card-body -->            
      </div>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
          <div class="col-md-12">
            <div class="card card-primary card-outline">
              <div class="card-body pad table-responsive">
                <table class="table table-bordered text-center">
                  <tbody>
                    <tr>
                      <td><button type="button" class="btn btn-block btn-warning">Acupuntura</button></td>
                      <td><button type="button" class="btn btn-block btn-danger">Alopata</button></td>
                      <td><button type="button" class="btn btn-block btn-secondary">Auriculoterapia</button></td>
                      <td><button type="button" class="btn btn-block btn-success">Homeopatica</button></td>
                      <td><button type="button" class="btn btn-block" style="background-color: #fd7e14; color: white;">Masajes</button></td>
                      <td><button type="button" class="btn btn-block btn-primary">Terapia Neural</button></td>
                      <td><button type="button" class="btn btn-block" style="background-color: #6f42c1; color: white;">Otros Servicios</button></td>
                  </tbody>
                </table>
              </div>
              <!-- /.card -->
            </div>
          </div>
          <!-- /.col -->
        </div>

    </section>
    <!-- /.content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-8">
            <div class="card card-primary">
              <div class="card-body p-0">
                <!-- THE CALENDAR -->
                <div id="calendario"></div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          
          <div class="col-md-4">
            <div class="row">
                <div class="table-responsive">
                  <table class="table table-striped">
                    <thead>
                    <tr>
                      <th>Fecha</th>
                      <th>Hora</th>
                      <th>Titulo</th>
                      <th>Contacto</th>
                    </tr>
                    </thead>
                    <tbody id="listaEventoCalendario">
                    </tbody>
                  </table>
                </div>
                <!-- /.col -->
              </div>
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div><!-- /.container-fluid -->
      
    </section>
  </div>
  <!-- /.content-wrapper -->
  
  <!-- .modal -->
  <div class="modal fade" id="modalCalendario">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title" id="modalEncabezado"></h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form name="formularioCalendario" id="formularioCalendario" method="POST">
          <input type="hidden" id="idevento" name="idevento">
          
          <div class="row">
            <div class="col-sm-4" id="modalVerFecha">
              <div class="form-group">
                <label class="control-label">Fecha:</label>
                <input type="date" class="form-control" id="modalFecha" name="modalFecha" onchange="listaHorasDisponibles();">
              </div>
            </div>
            <div class="col-sm-8">
              <div class="form-group">
                <label class="control-label">Nombre Paciente o Titulo:</label>
                <input type="text" class="form-control" id="modalTitulo" name="modalTitulo" required="">
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-sm-6">
              <div class="input-group mb-2">
                <div class="input-group-prepend">
                  <span class="input-group-text"> <i class="fas fa-phone-square-alt"></i></span>
                </div>
                <input name="modalTelefono" id="modalTelefono" type="tel" class="form-control" placeholder="Telefono..." maxlength="10" autocomplete="off">
              </div>
            </div>
            <div class="col-sm-6">
              <div class="input-group mb-2">
                <div class="input-group-prepend">
                  <span class="input-group-text"> <i class="fas fa-envelope"></i></span>
                </div>
                <input name="modalEmail" id="modalEmail" type="email" class="form-control" placeholder="Correo..." autocomplete="off">
              </div>
            </div>
          </div>
          <div class="form-group">
            <div class="input-group mb-2">
              <div class="input-group-prepend">
                <span class="input-group-text"> <i class="far fa-comment-dots"></i></span>
              </div>
              <input type="text" class="form-control" id="modalDescripcion" name="modalDescripcion" placeholder="Notas & Descripcion..." autocomplete="off">
            </div>            
          </div>
          <div class="row">
            <div class="col-sm-6">
              <!-- select -->
              <div class="form-group">
                <label>Empieza Horas Disponibles</label>
                <select name="modalHoraEmpieza" id="modalHoraEmpieza" class="form-control" size="3">
                </select>
              </div>
            </div>
            <select name="modalHoraTerminaOriginal" id="modalHoraTerminaOriginal" style="display: none;"></select>
            <div class="col-sm-6">
              <div class="form-group">
                <label>Termina Horas Disponibles</label>
                <select name="modalHoraTermina" id="modalHoraTermina" class="form-control" size="3">
                </select>
              </div>
            </div>
          </div>
          
          <!-- Colores -->  
          <div class="row">
            <div class="col-sm-4">
              <!-- select -->
              <div class="form-group">
                <label>Color de Texto</label>
                <div class="form-group clearfix">
                  <i class="fas fa-circle nav-icon"></i>
                  <div class="icheck-gray d-inline">
                    <input type="radio" id="TextNegro" name="colorText" value="212529">
                    <label for="TextNegro"></label>  
                  </div>

                  <i class="far fa-circle nav-icon"></i>
                  <div class="icheck-gray d-inline">
                    <input type="radio" id="TextBlaco" name="colorText" value="ffffff" checked="">
                    <label for="TextBlaco"></label>                
                  </div>

                </div>
              </div>
            </div>
            
            <div class="col-sm-12">
              <div class="form-group">
                <label>Color de fondo para el evento</label>
                <div class="form-group clearfix">
                  
                  <i class="fas fa-square text-warning"></i>
                  <div class="icheck-warning d-inline">
                    <input type="radio" id="Acupuntura" name="colorFondo" value="ffc107">
                    <label for="Acupuntura">Acupuntura</label>  
                  </div>
                  
                  <i class="fas fa-square text-danger"></i>
                  <div class="icheck-danger d-inline">
                    <input type="radio" id="Alopata" name="colorFondo" value="dc3545">
                    <label for="Alopata">Alopata</label>  
                  </div>
                  
                  <i class="fas fa-square text-gray"></i>
                  <div class="icheck-gray d-inline">
                    <input type="radio" id="Auriculoterapia" name="colorFondo" value="6c757d">
                    <label for="Auriculoterapia">Auriculoterapia</label>  
                  </div>
                  
                  <br><i class="fas fa-square text-success"></i>
                  <div class="icheck-success d-inline">
                    <input type="radio" id="Homeopatica" name="colorFondo" value="28a745">
                    <label for="Homeopatica">Homeopatica</label>  
                  </div>
                  
                  <i class="fas fa-square text-orange"></i>
                  <div class="icheck-orange d-inline">
                    <input type="radio" id="Masajes" name="colorFondo" value="fd7e14">
                    <label for="Masajes">Masajes</label>  
                  </div>
                  
                  <i class="fas fa-square text-primary"></i>
                  <div class="icheck-primary d-inline">
                    <input type="radio" id="Neural" name="colorFondo" value="007bff">
                    <label for="Neural">Terapia Neural</label>  
                  </div>
                  
                  <br><i class="fas fa-square text-purple"></i>
                  <div class="icheck-purple d-inline">
                    <input type="radio" id="Otros" name="colorFondo" value="6f42c1">
                    <label for="Otros">Otros Servicios</label>  
                  </div>

                </div>
              </div>
            </div>
            
          </div>
          <!-- /Colores -->
          
        </form>
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal"><i class="fas fa-times"></i> Cerrar</button>
          <button type="button" class="btn btn-success" id="btnGuardarModal"><i class="fas fa-save"></i> Guardar</button>
          <button type="button" class="btn btn-warning" id="btnEditarModal"><i class="fas fa-edit"></i> Actualizar</button>
          <button type="button" class="btn btn-danger" id="btnBorrarModal"><i class="fas fa-trash"></i> Borrar Evento</button>          
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->
  
<?PHP require 'footer.php'; ?>
  <script type="text/javascript" src="scripts/citaCalendario.js"></script>