<?php 
#Incluímos inicialmente la conexión a la base de datos
require_once "../config/Conexion.php";

Class Citas{
  #https://es.stackoverflow.com/questions/146728/consulta-obteber-registros-entre-una-hora-inicial-y-una-final
  
  #Variables para nombres generales en el Modelo...
  public $tablaDB = "eventoCalendario";
  private $caracteres_malos = array("'", '"', '<', '>', '\\', '/', '!', '¡', '#', '$', '%', '&', '¿','?', '|');
  
  public function __construct(){ }  
   
  public function listarEvento(){
    $query = "SELECT * "
            . "FROM $this->tablaDB "
            . "WHERE DATE(empieza) > DATE_ADD(NOW(), INTERVAL -31 DAY) "
            . "AND idcontrol = '".$_SESSION['idcontrol']."' ";
    return ejecutarConsulta($query); 
  }
  
  public function AgregarEventoCalendario($titulo, $telefono, $email, $descripcion, $empieza, $termina, $colorfondo, $colortexto){
    $query = "INSERT INTO $this->tablaDB (idusuario, idcontrol, titulo, telefono, correo, descripcion, empieza, termina, colorfondo, colortexto) "
            . "VALUES ('".$_SESSION['idusuario']."', '".$_SESSION['idcontrol']."', '$titulo', '$telefono', '$email', '$descripcion', '$empieza', '$termina', '$colorfondo', '$colortexto');";
    
    #Guardar accion en bitacora para llevar un registro.
    $queryR = str_replace($this->caracteres_malos, '', $query);
    $bitacora = "INSERT INTO bitacora (fecha, accion, descripcion, MySQL, recupera, idusuario, idcontrol) "
	    . "VALUES (NOW(), 1, 'Agregar un evento al calendario $titulo', '$queryR', '',  '".$_SESSION['idusuario']."', '".$_SESSION['idcontrol']."'); ";
    ejecutarConsulta($bitacora);    
    return ejecutarConsulta($query);
  }
  
  public function EditarEventoCalendario($idEventoCalendario, $titulo, $telefono, $email, $descripcion, $empieza, $termina, $colorfondo, $colortexto){
    $query = "UPDATE $this->tablaDB "
	    . "SET titulo='$titulo', telefono='$telefono', correo='$email', descripcion='$descripcion', empieza='$empieza', termina='$termina', colorfondo='$colorfondo', colortexto='$colortexto' "
	    . "WHERE id$this->tablaDB = '$idEventoCalendario' "
            . "AND idcontrol = '".$_SESSION['idcontrol']."' ";

    #Guardar accion en bitacora para llevar un registro.
    $queryR = str_replace($this->caracteres_malos, '', $query);
    $recupera = str_replace($this->caracteres_malos, '', $recupera);
    $bitacora = "INSERT INTO bitacora (fecha, accion, descripcion, MySQL, recupera, idusuario, idcontrol) "
            . "VALUES (NOW(), 2, 'Evento de calendario $titulo fue actualizado.', '$queryR', '', '".$_SESSION['idusuario']."', '".$_SESSION['idcontrol']."'); ";
    ejecutarConsulta($bitacora);
    return ejecutarConsulta($query);
  }
  
  public function listaEventoCalendario($VerSQL=false){
    $query = "SELECT DATE_FORMAT(empieza, '%y-%m-%d' ) AS fecha, "
            . "DATE_FORMAT(empieza, '%H:%i' ) AS empieza, "
            . "DATE_FORMAT(termina, '%H:%i' ) AS termina, "
            . "titulo, telefono, correo, descripcion, colorfondo "
            . "FROM $this->tablaDB "
            . "WHERE DATE(empieza) BETWEEN DATE_ADD(NOW(), INTERVAL -1 DAY) AND DATE_ADD(NOW(), INTERVAL +30 DAY) "
            . "AND idcontrol = '".$_SESSION['idcontrol']."' "
            . "ORDER BY DATE(empieza) ASC "
            . "LIMIT 10 ";    
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }
  }
  
  public function listaHorasDisponibles($fechaBusco, $VerSQL=false) {
    $query = "SELECT DATE_FORMAT(empieza, '%H:%i') AS empieza, "
            . "DATE_FORMAT(termina, '%H:%i' ) AS termina "
            . "FROM $this->tablaDB "
            . "WHERE DATE(empieza) = '$fechaBusco' "
            . "AND idcontrol = '".$_SESSION['idcontrol']."' "
            . "ORDER BY empieza ";    
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }
  }
  
  public function borraEventoCalendario($idRegistro, $evento) {
    $query = "DELETE FROM $this->tablaDB "
         . "WHERE id$this->tablaDB = '$idRegistro' ";
    
    $queryR = str_replace($this->caracteres_malos, '', $query);
    $bitacora = "INSERT INTO bitacora (fecha, accion, descripcion, MySQL, recupera, idusuario, idcontrol) "
	    . "VALUES (NOW(), 3, 'Evento de calendario eliminado.', '$queryR', '$evento', '".$_SESSION['idusuario']."', '".$_SESSION['idcontrol']."'); ";
    ejecutarConsulta($bitacora);
    return ejecutarConsulta($query);
  }  
  
  public function listarCliente($VerSQL=false){    
    $query = "SELECT `titulo`, `empieza`, `telefono`, `correo` "
            . "FROM `$this->tablaDB` "
            . "WHERE `idcontrol` = '".$_SESSION['idcontrol']."' "
            . "GROUP BY `titulo` "
            . "ORDER BY `titulo` ASC;";
    
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }
  }
  
  public function borraTitulo($titulo) {
    $query = "DELETE FROM `$this->tablaDB` "
         . "WHERE `titulo` = '$titulo' "
         . "AND `idcontrol` = '".$_SESSION['idcontrol']."'";
    
    $queryR = str_replace($this->caracteres_malos, '', $query);
    $bitacora = "INSERT INTO `bitacora` (`fecha`, `accion`, `descripcion`, `MySQL`, `recupera`, `idusuario`, `idcontrol`) "
	    . "VALUES (NOW(), 3, 'Titulo $titulo eliminado de los eventos calendario.', '$queryR', '$evento', '".$_SESSION['idusuario']."', '".$_SESSION['idcontrol']."'); ";
    ejecutarConsulta($bitacora);
    return ejecutarConsulta($query);
  }
} ?>