<?php 
#Incluímos inicialmente la conexión a la base de datos
require_once "../config/Conexion.php";

Class ReporteVenta{
  
  #Variables para nombres generales en el Modelo...
  public $tablaDB = "venta";
  private $caracteres_malos = array("'", '"', '<', '>', '\\', '/', '#', '%', '&', '¿','?', '|');
  
  public function __construct(){ }  
  
  public function rvPorTiempo($fechainicio, $fechafin, $VerSQL=false){
    if($fechainicio!=='' AND $fechafin!==''){
      $cf = "DATE(c.fecha) BETWEEN '$fechainicio' AND '$fechafin' ";
    }elseif($fechainicio!=='' AND $fechafin===''){
      $cf = "DATE(c.fecha) = '$fechainicio' ";
    } else {
       $cf = "DATE(c.fecha) = 'NULL' ";
    }
    
    $query = "SELECT a.idproducto, b.codigosat, b.producto, SUM(a.cantidad) AS cantidad, SUM(a.subtotal) AS subtotal, SUM(a.iva) AS iva, "
            . "SUM(a.total) AS total, c.idcontribuyente "
            . "FROM producto_venta a "
            . "INNER JOIN producto b ON a.idproducto = b.idproducto "
            . "INNER JOIN venta c ON a.idventa = c.idventa "
            . "WHERE $cf "
            . "AND a.idcontrol = '".$_SESSION['idcontrol']."' "
            . "AND b.idcontrol = '".$_SESSION['idcontrol']."' "
            . "AND c.idcontrol = '".$_SESSION['idcontrol']."' "
            . "GROUP BY a.idproducto, c.idcontribuyente; ";
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }    
  }
  
  public function rvPorVenta($fechainicio, $fechafin, $VerSQL=false){
    if($fechainicio!=='' AND $fechafin!==''){
      $cf = "DATE(c.fecha) BETWEEN '$fechainicio' AND '$fechafin' ";
    }elseif($fechainicio!=='' AND $fechafin===''){
      $cf = "DATE(c.fecha) = '$fechainicio' ";
    } else {
       $cf = "DATE(c.fecha) = 'NULL' ";
    }
    
    $query = "SELECT a.idventa, DATE(c.fecha) AS fecha, a.idproducto, b.codigosat, b.producto, SUM(a.cantidad) AS cantidad, SUM(a.subtotal) AS subtotal, "
            . "SUM(a.iva) AS iva, SUM(a.total) AS total, c.idcontribuyente "
            . "FROM producto_venta a "
            . "INNER JOIN producto b ON a.idproducto = b.idproducto "
            . "INNER JOIN venta c ON a.idventa = c.idventa "
            . "WHERE $cf "
            . "AND a.idcontrol = '".$_SESSION['idcontrol']."' "
            . "AND b.idcontrol = '".$_SESSION['idcontrol']."' "
            . "AND c.idcontrol = '".$_SESSION['idcontrol']."' "
            . "GROUP BY a.idventa, a.idproducto "
            . "ORDER BY a.idventa, c.idcontribuyente; ";
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }
  }
} ?>