<?php 
#Incluímos inicialmente la conexión a la base de datos
require_once "../config/Conexion.php";

Class Resurtir{
  
  #Variables para nombres generales en el Modelo...
  public $tablaDB = "contribuyente";
  private $caracteres_malos = array("'", '"', '<', '>', '\\', '/', '!', '¡', '#', '$', '%', '&', '¿','?', '|','-');
  
  public function __construct(){ }  
  
  public function insertarProveedor($idcontribuyente, $nombre, $direccion){
    #Trabajar variables recibidas    
    $nombre = str_replace($this->caracteres_malos, '', $nombre);
    $idcontribuyente = str_replace($this->caracteres_malos, '', $idcontribuyente);
    $direccion = str_replace($this->caracteres_malos, '', $direccion);
    
    $query = "INSERT INTO contribuyente (idcontribuyente, nombre, direccion) "
            . "VALUES ('$idcontribuyente', '$nombre', '$direccion'); ";  
    return ejecutarConsulta($query);
  }
  
  public function editarProveedor($existerfc, $idcontribuyente, $nombre, $direccion){
    $nombre = str_replace($this->caracteres_malos, '', $nombre);
    $idcontribuyente = str_replace($this->caracteres_malos, '', $idcontribuyente);
    $direccion = str_replace($this->caracteres_malos, '', $direccion);
    
    $query = "UPDATE contribuyente "
	    . "SET idcontribuyente='$idcontribuyente', nombre='$nombre', direccion='$direccion' "
	    . "WHERE idcontribuyente = '$existerfc'; ";
    return ejecutarConsulta($query);
  }
  
  public function insertaResurtir($factura, $idcontribuyente, $idproducto, $cantidad, $caducidad, $compra) {
    #Trabajar variables recibidas    
    $factura = str_replace($this->caracteres_malos, '', $factura);
    $idcontribuyente = str_replace($this->caracteres_malos, '', $idcontribuyente);
    
    if($caducidad === '') $caducidad = 'NULL'; else $caducidad = "'$caducidad'";
    
    $query = "INSERT INTO `resurtir` (`idproducto`, `idcontrol`, `idcontribuyente`, `fecha`, `factura`, `cantidad`, `caducidad`, `existencia`, `compra`) "
            . "VALUES ('$idproducto', '".$_SESSION['idcontrol']."', '$idcontribuyente', NOW(), '$factura', '$cantidad', $caducidad, '$cantidad', '$compra'); ";
    
    #Guardar accion en bitacora para llevar un registro.
    $queryR = str_replace($this->caracteres_malos, '', $query);
    $bitacora = "INSERT INTO bitacora (fecha, accion, descripcion, MySQL, recupera, idusuario, idcontrol) "
	    . "VALUES (NOW(), 1, 'Producto $idproducto resurtidon con $cantidad', '$queryR', '', '".$_SESSION['idusuario']."', '".$_SESSION['idcontrol']."'); ";
    ejecutarConsulta($bitacora);    
    return ejecutarConsulta($query);
  }
  
  public function resurtirProducto($codigoBarras, $cantidad, $existenciaminima, $compra, $ganancia, $subtotal, $iva, $total){   
    if(!is_numeric($cantidad)) $cantidad = 0;
    
    $query = "UPDATE producto "
	    . "SET existencia = existencia + $cantidad, existenciaminima='$existenciaminima', compra='$compra', ganancia='$ganancia', subtotal='$subtotal', iva='$iva', total='$total' "
	    . "WHERE idproducto = '$codigoBarras' "
          . "AND idcontrol = '".$_SESSION['idcontrol']."'; ";
    return ejecutarConsulta($query);
  }
  
  public function validaCodigo($clave) {
    $query = "SELECT marca, producto, descripcion, cantidad, unidadmedida, existencia, existenciaminima, compra, ganancia, subtotal, iva, total "
            . "FROM producto "
            . "WHERE idproducto = '$clave' "
            . "AND idcontrol = '".$_SESSION['idcontrol']."'; ";
    return ejecutarConsulta($query);
  }
  
  public function listaEventos($VerSQL=false){
    $query = "SELECT a.idresurtir, a.fecha, a.factura, a.idcontribuyente, a.idproducto, b.producto, a.cantidad, a.caducidad, a.existencia, a.compra "
            . "FROM resurtir a "
            . "INNER JOIN producto b ON a.idproducto = b.idproducto "
            . "WHERE a.existencia > 0 "
            . "AND a.idcontrol = '".$_SESSION['idcontrol']."' "
            . "AND b.idcontrol = '".$_SESSION['idcontrol']."' "
            . "ORDER BY a.fecha DESC "
            . "LIMIT 30; ";
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }
  }
  
  public function validaRFC($rfc){
    if(strlen($rfc) < 10 ){
      $where = "WHERE idcontribuyente LIKE '$rfc%' ";
    }else{
      $where = "WHERE idcontribuyente = '$rfc' LIMIT 1 ";
    }
    
   $query = "SELECT * "
            . "FROM contribuyente "
            . "$where ";            
    return ejecutarConsulta($query);
  }
  
  public function buscaContribuyente($buscando){    
    $query = "SELECT `idcontribuyente`, `nombre`, `direccion` "
            . "FROM `contribuyente` "
            . "WHERE `idcontribuyente` LIKE '$buscando%' "
            . "OR `nombre` LIKE '%$buscando%'; ";
    return ejecutarConsulta($query);
  }
  
  public function Buscar($control, $VerSQL=false){    
    $query = "SELECT a.idresurtir, a.fecha, a.factura, a.idcontribuyente, a.idproducto, b.producto, a.cantidad, a.caducidad, a.existencia, a.compra "
            . "FROM resurtir a "
            . "INNER JOIN producto b ON a.idproducto = b.idproducto "
            . "WHERE a.idproducto LIKE '%$control%' "
            . "AND a.idcontrol = '".$_SESSION['idcontrol']."' "
            . "AND b.idcontrol = '".$_SESSION['idcontrol']."' "
            . "ORDER BY a.fecha DESC; ";
    if($VerSQL){ echo $query; }
    else{ return ejecutarConsulta($query); }
  }
  
  public function buscaCoincidencia($buscaCodigo){
    $query = "SELECT idproducto, producto, marca, descripcion "
            . "FROM producto "
            . "WHERE idcontrol = '".$_SESSION['idcontrol']."' "
            . "AND (marca LIKE '%$buscaCodigo%' "
            . "OR producto LIKE '%$buscaCodigo%'); ";
    return ejecutarConsulta($query);
  }
  
  public function editarResurtir($idresurtir, $cantidad, $caducidad){
    if($caducidad === '') $caducidad = 'NULL'; else $caducidad = "'$caducidad'";
    
    $query = "UPDATE `resurtir` "
	    . "SET `cantidad` = '$cantidad', `existencia` = '$cantidad', `caducidad` = $caducidad "
	    . "WHERE `idresurtir` = '$idresurtir'; ";
    return ejecutarConsulta($query);    
  }
  
  public function editarResurtirProducto($codigoBarras, $cantidad, $operador){   
    if(!is_numeric($cantidad)) $cantidad = 0;
    
    $query = "UPDATE `producto` "
	    . "SET `existencia` = `existencia` $operador '$cantidad' "
	    . "WHERE `idproducto` = '$codigoBarras' "
            . "AND `idcontrol` = '".$_SESSION['idcontrol']."'; ";
    return ejecutarConsulta($query);
  }
    
} ?>