<?PHP require 'header.php'; ?>

<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-12">
            <h1><i class="fas fa-hourglass-half"></i> Reportes para caducidad de productos.</h1>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">        
        <div class="col-md-6">
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">
                  <i class="fas fa-hourglass-half"></i> 
                    Reporte de caducidad por días restantes para caducar:
                </h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="row">
                  <div class="col-md-6">
                    <label>Busqueda Inicial.</label>
                    <div class="input-group mb-2">
                      <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fas fa-calendar-check"></i></span>
                      </div>
                      <input name="inicio" id="inicio" type="number" class="form-control" value="-7" required="">  
                    </div>
                  </div>
                  <div class="col-md-6">
                    <label>Busqueda Final.</label>
                    <div class="input-group mb-2">
                      <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fas fa-calendar-check"></i></span>
                      </div>
                      <input name="fin" id="fin" type="number" class="form-control" value="365" required="">
                    </div>
                  </div>
                </div>                  
              </div>
              <div class="card-footer">
                <div class="input-group mb-2">
                  <button type="button" class="btn btn-block btn-outline-info" id="btnBuscar">
                    <i class="fas fa-file-invoice-dollar"></i> Reportar proximos a caducar...
                  </button>
                </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.col -->
        
        <div class="col-md-6">
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">
                  <i class="fas fa-hourglass-half"></i> 
                    Reporte de productos caducados por fecha:
                </h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="row">
                  <div class="col-md-6">
                    <label>Fecha Inicial:</label>
                    <div class="input-group mb-2">
                      <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fas fa-calendar-check"></i></span>
                      </div>
                      <input name="inicioYaCaduco" id="inicioYaCaduco" type="date" class="form-control" value="<?php $fecha=date('Y-m-d'); echo date('Y-m-d',strtotime($fecha.'- 1 year')); ?>">  
                    </div>
                  </div>
                  <div class="col-md-6">
                    <label>Fecha Final:</label>
                    <div class="input-group mb-2">
                      <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fas fa-calendar-check"></i></span>
                      </div>
                      <input name="finYaCaduco" id="finYaCaduco" type="date" class="form-control" value="<?=$fecha;?>">
                    </div>
                  </div>
                </div>                  
              </div>
              <div class="card-footer">
                <div class="input-group mb-2">
                  <button type="button" class="btn btn-block btn-outline-info" id="btnBuscarYaCaduco">
                    <i class="fas fa-file-invoice-dollar"></i> Reportar ya Caducado...
                  </button>
                </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      
      
    </section>
      
    <section class="content">      
    <!-- /Lista de Eventos -->
    <div class="card card-info" id="divEventos">        
      <div class="card-body p-0">
        <table class="table table-striped">
          <thead>
            <tr>
              <th colspan="5" class="text-info">
                <label id="repTitulo"><i class="fas fa-calendar-check"></i></label>
              </th>
            </tr>
            <tr class="text-blue">
              <th>Codigo</th>
              <th>Producto</th>
              <th>Adquiridos</th>
              <th id="th4">th4</th>
              <th>Fecha Caducidad</th>
              <th id="th6">th6</th>
              <th></th>
            </tr>
          </thead>
          <tbody id="listaEventos">
          </tbody>
        </table>
      </div>
      <!-- /.card-body -->
    </div>
<!-- /Lista de Eventos -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
<?PHP require 'footer.php'; ?>
<script type="text/javascript" src="scripts/reporteCaducidad.js"></script>




