var DataTable; //Variable para dataTable.
var toastr; //Varible de alertas
var ajaxFile = 'ajax/cajaChica.php'; //Variable para archivo de ajax.

//Funcion que se ejecuta al inicio
function iniciar(){
  corteCaja();
  listarRegistros();
}

function listarRegistros(){
  DataTable = $('#DataTable').dataTable({
    "aProcessing": true, //Activa el prosedamietno del datatables
    "aServerSide": true, //Paginacion y filtrado realizados por el servidor
    dom: 'Bfrtip', //Definimos los elementos del control de tabla
    buttons:['copyHtml5','excelHtml5','csvHtml5','pdf'],
    "ajax":{
      url: ajaxFile+ '?op=listar', //Obtener los valores desde url
      type: "get",
      dataType: "json", //Datos codificados mediante json
      error:function(e){ //en caso de errores
	//console.log(e.responseText);
      }
    },
    "createdRow": function( row, data, dataIndex ) { //Establecer color a las filas
      //Condiciones
      var varColn = 4;
      if(data[varColn] === 'A'){
        $(row).css('background-color','rgba(0, 123, 255, .3)'); //azul - primary
      }
      if(data[varColn] === '1'){
        $(row).css('background-color','rgba(255, 193, 7, .3)'); //amarillo - warning
      }
      if(data[varColn] === 'A'){
        $(row).css('background-color','rgba(102, 16, 242, .3)'); //indigo - indigo
      }
      if(data[varColn] === 'A'){
        $(row).css('background-color','rgba(23, 162, 184, .3)'); //perry - info
      }      
      if(data[varColn] === '2'){
        $(row).css('background-color','rgba(40, 167, 69, .2)'); //verde - success
      }
      if(data[varColn] === 'A'){
        $(row).css('background-color','rgba(230, 230, 230, .3)'); //gris - default
      }
      if(data[varColn] === '0'){
        $(row).css('background-color','rgba(220, 53, 69, .3)'); //rojo - danger
      }
    },
    "bBestroy": true,
    "iDisplayLength": 40, //Paginacion de X en X registros.
    "order": [[0, "desc"]] //Ordenar (columna,orden).
  }).DataTable();
}

$('#btnCajaChica').click(function(){
  var monto = $('#monto').val();
  var accion = $("input[type='radio'][name='accion']:checked").val();
  var descripcion = $('#descripcion').val();
  
  //console.log(monto,accion,descripcion);
  var jqxhr = $.post(ajaxFile+ "?op=agregarCajaChica", {monto:monto, accion:accion, descripcion:descripcion}, function (r){
    //console.log(r);
  })
  .done(function(r) {
    if(accion === '0'){
      monto = '-'+monto;
      toastr.success('Monto $'+monto+' registrado.');
    }else{
      toastr.warning('El Monto de caja chica se ajusto en $'+monto);
    }
    
    $('#monto').val(null);
    $('#accion').val(null);
    $('#descripcion').val(null);
    $("#gasto").attr('checked',true);    
  })
  .fail(function(r) {
    console.log(r);
    toastr.error('jQuery Agregar Caja Chica . . .');
  });
});

function corteCaja(){
  var jqxhr = $.post(ajaxFile+ "?op=corteCaja", function (resultado){
    console.log(resultado);
  })
  .done(function(resultado) {
    $('#corteCaja').html(resultado);
  })
  .fail(function(resultado) {
    console.log(resultado);
    toastr.error('jQuery Corte de Caja . . .');
  });
}

iniciar(); //Ejecuta iniciar, para que simpre se ejecute.