var DataTable; //Variable para dataTable.
var Swal,toastr; //Varible de alertas
var ajaxFile = 'ajax/citaCalendario.php'; //Variable para archivo de ajax.
var camposForm = ['idevento', 'modalFecha', 'modalTitulo', 'modalDescripcion','modalTelefono','modalEmail']; //Nombre de ID en doc php form.

//Funcion que se ejecuta al inicio
function iniciar(){ 
  Calendario();
  limpiar();
  listaEventoCalendario();  
  $('#ListadoClientes').hide( "slow" ); //Salida  
}

function limpiar(){
  //Se usa Gquery $("#NombreDelObjeto).val("Valor a mandar");
  for(i=0; i<camposForm.length; i++){
    $("#"+camposForm[i]).val(null);
    //$("#"+camposForm[i]).selectpicker('refresh');
  }
  
  $('#modalCalendario').fadeOut();
  $('#divFormulario').fadeOut();
  $('#btnEditarModal').hide();
  $('#btnBorrarModal').hide();
  
  $('#modalHoraEmpieza').empty();
  $('#modalHoraTermina').empty();
  $('#modalHoraTerminaOriginal').empty();
  $("input[type='radio'][name='colorFondo'][value='6f42c1']").prop("checked", true);
}

function mostrarForm(){
  limpiar();
  $('#modalCalendario').modal();//Llama al model  
  $('#modalEncabezado').html('Nuevo Evento...');
  $('#modalVerFecha').fadeIn(1000);
}

function Calendario(){ //    $(document).ready(function(){
  $('#calendario').fullCalendar({
    header:{
      left: 'today,prev,next,botonAgregar',
      center: 'title',
      right: 'month,basicWeek,basicDay'
      //right: 'month,basicWeek,basicDay,agendaWeek,agendaDay'
    },
    customButtons:{
      botonAgregar:{
        text: 'Agregar Evento',
        click: function(){
          mostrarForm();
        }
      }
    },
    dayClick: function(date, jsEvent, view) { //Regrear valores donde damos clic
      //https://fullcalendar.io/docs/v3/dayClick
      //console.log('Valor ' + date.format() +' CordenadasXY '+jsEvent.pageX + ',' + jsEvent.pageY +' Vista '+ view.name);
      limpiar();
      $('#modalEncabezado').html('Nuevo evento el ' +date.format());
      $('#btnGuardarModal').show();
      $('#modalVerFecha').hide();
      $('#btnEditarModal').hide();
      $('#btnBorrarModal').hide();
      $('#modalFecha').val(date.format());
      //modalFecha
      //$(this).css('background-color','#2e9db8'); //Establecer un color
      $('#modalCalendario').modal();//Llama al model
      
      listaHorasDisponibles(date.format());
    },
          
    events: ajaxFile+ "?op=listarEvento", //Listar los eventos para el calendario
    //https://www.youtube.com/watch?v=oviNyWTu_sU&list=PLSuKjujFoGJ3xqSJHnZUR-INEO71t1znq&index=5
    //https://www.youtube.com/watch?v=1wCv52MDejY&list=PLSuKjujFoGJ3xqSJHnZUR-INEO71t1znq&index=7

    eventClick: function(calEvent,jsEvent,view){ //Regresa los valores del evento clic
      //console.log(calEvent);
      $('#modalEncabezado').html('Editar evento ' +calEvent.start._i);
      $('#modalEncabezado').val(calEvent.start._i);
      $('#modalVerFecha').show();
      $('#btnEditarModal').show();
      $('#btnBorrarModal').show();
      $('#btnGuardarModal').hide();
      
      var separaFechaIni = calEvent.start._i.split(' '); //Separa en arreglo Var1,Var2,etc..
      var separaFechaFin = calEvent.end._i.split(' '); //Separa en arreglo Var1,Var2,etc..
      
      $('#modalFecha').val(separaFechaIni[0]);
      
      var HIni = '<option value="'+separaFechaIni[1].substring(0,5)+'" selected="">'+separaFechaIni[1].substring(0,5)+' HRS Actual</option>';
      var HFin = '<option value="'+separaFechaFin[1].substring(0,5)+'" selected="">'+separaFechaFin[1].substring(0,5)+' HRS Actual</option>';
      listaHorasDisponibles(separaFechaIni[0],HIni,HFin);           
      
      $('#modalTitulo').val(calEvent.title);
      $('#modalTelefono').val(calEvent.telefono);
      $('#modalEmail').val(calEvent.email);
      $('#modalDescripcion').val(calEvent.descripcion);
      $('#idevento').val(calEvent.idevento);
      $('#modalCalendario').modal();//Llama al model
      
      var colorfondo = calEvent.color.split('#'); //Separa en arreglo Var1,Var2,etc..
      $("input[type='radio'][name='colorFondo'][value='"+colorfondo[1]+"']").prop("checked", true);
      
      var colorText = calEvent.textColor.split('#'); //Separa en arreglo Var1,Var2,etc..
      $("input[type='radio'][name='colorText'][value='"+colorText[1]+"']").prop("checked", true);
    }
  });
}

$('#btnEditarModal').click(function(){
  var verifica = 0;
  var campo='';
  if($('#modalHoraTermina').val()=== null){ verifica++; campo = 'Hora de Finalizacion'; }
  if($('#modalHoraEmpieza').val()=== null){ verifica++; campo = 'Hora de Inicio'; }
  if($('#modalTitulo').val()=== ''){ verifica++; campo = 'Titulo o Nombre'; }
  if($('#modalFecha').val()=== ''){ verifica++; campo = 'Fecha'; }
  
  if(verifica > 0){
    toastr.warning('Falta indicar '+campo+'...');
  }else{
    GuardarModal();
  }  
});

$('#btnGuardarModal').click(function(){
  var verifica = 0;
  var campo='';
  if($('#modalHoraTermina').val()=== null){ verifica++; campo = 'Hora de Finalizacion'; }
  if($('#modalHoraEmpieza').val()=== null){ verifica++; campo = 'Hora de Inicio'; }
  if($('#modalTitulo').val()=== ''){ verifica++; campo = 'Titulo o Nombre'; }
  if($('#modalFecha').val()=== ''){ verifica++; campo = 'Fecha'; }
  
  if(verifica > 0){
    toastr.warning('Falta indicar '+campo+'...');
  }else{
    GuardarModal();
  }    
});

function GuardarModal(){
  var NuevoEvento = {
    title: $('#modalTitulo').val(),
    descripcion: $('#modalDescripcion').val(),
    start: $('#modalFecha').val()
  };
 
 var formDatos = new FormData($("#formularioCalendario")[0]); //Para obtener los datos del id
 //console.log(formDatos);
  $.ajax({ //Metodo ajax
    url: ajaxFile+ "?op=GuardarModal", //archivo donde lo envia
    type: "POST",
    data: formDatos, //La varible var formData = new FormData mas arriba
    contentType: false,
    processData: false,
        
    success: function(respuesta){
      //console.log(respuesta);
      var separar = respuesta.split(','); //Separa en arreglo Var1,Var2,etc..
      if(separar[0] === 'success'){ toastr.success(separar[1]); }
      if(separar[0] === 'error'){ 
        console.log(respuesta);
        toastr.error(separar[1]);
      }
    }
  });
  
  if($('#idevento').val() === ''){
   $('#calendario').fullCalendar('renderEvent', NuevoEvento); //Recargar el calendario     
  }else{
    $('#calendario').fullCalendar('refetchEvents'); //Recargar el calendario
  }
  
  $('#modalCalendario').modal('toggle'); //Cerrar al model con (toggle)
  $('.listaEventos').remove(); //Borrar etiquetas extras 
  listaEventoCalendario();  
}

function listaEventoCalendario(){  
  $.get(ajaxFile+ "?op=listaEventoCalendario", function(data, status){
    //console.log(data);
    $('#listaEventoCalendario').append(data); //Agrega html a id
  });  
}

function listaHorasDisponibles(fechaBusco,HIni,HFin){
  var fechaBusco = $('#modalFecha').val();
  var resultado;
  
  $('#modalHoraTermina').empty(); //Vacciar option...
  $('#modalHoraEmpieza').empty();
  
  $.post(ajaxFile+ "?op=listaHorasDisponibles",{fechaBusco:fechaBusco}, function(data, status){
    if(HIni!=='' && HFin!==''){
      $('#modalHoraEmpieza').append(HIni);
      $('#modalHoraTermina').append(HFin);
    }
    //console.log(data);
    resultado = data.split('#');
    $('#modalHoraEmpieza').append(resultado[0]);
    $('#modalHoraTerminaOriginal').empty().append(resultado[1]);
  });  
}

//Si cambia o selecciona otra hora
$("#modalHoraEmpieza").change(function() {
  //$('select #formularioCalendario').formSelect(); //Selecciona el formulario a utilizar this
  var HoraSelec = parseInt( $('#modalHoraEmpieza').val().replace(':','') );
  var este;     
  $('#modalHoraTermina').empty(); //Vacciar option...

  $("#modalHoraTerminaOriginal option").each(function(){
    if ($(this).val() !== "" ){
      este = parseInt( $(this).val().replace(':','') );
      if( este > HoraSelec ){
        $('#modalHoraTermina').append('<option value="'+$(this).val()+'">'+$(this).text()+'</option>');
        //console.log(este+'>'+HoraSelec);
      }  
    }
  });
});

$('#btnBorrarModal').click(function(){
  Swal.fire({
    title: 'Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Si, borrar !'
  }).then((result) => {
    if (result.isConfirmed) {
      var idRegistro = $('#idevento').val();
      var evento = $('#modalTitulo').val();
      $.get(ajaxFile+ "?op=borraEventoCalendario",{idRegistro:idRegistro, evento:evento}, function(data, status){
        toastr.error('Evento de calendario borrado...');
      });
      $('#modalCalendario').modal('toggle'); //Cerrar al model con (toggle)
      $('#calendario').fullCalendar('refetchEvents'); //Recargar el calendario
      
      Swal.fire(
        'Borrado!',
        'Tu registro a sido eliminado.',
        'success'
      );
    }
  });  
});

$('#listarCliente').click(function(){ 
  var jqxhr = $.post(ajaxFile+ "?op=listarCliente", function(data, status){
    $('#ListadoClientes').slideDown('slow'); //Entrada
    $('.listaClientes').remove(); //Borrar etiquetas extras 
  })
  .done(function(data) {
    $('#listaClientes').append(data); //Agrega html a id
  })
  .fail(function(data) {
    console.log(data);
    toastr.error('jQuery Lista Cliente . . .');
  });
});

function borraTitulo(id, titulo){
  var jqxhr = $.post(ajaxFile+ "?op=borraTitulo",{borraTitulo:titulo}, function(data, status){
    //console.log(data, id, titulo);
  })
  .done(function(data) {
    toastr.info('Registro '+titulo+ ' fue eliminado.');
    $('#LC'+id).remove(); //Borrar etiquetas extras     
  })
  .fail(function(data) {
    console.log(data);
    toastr.error('jQuery Borrar titulo . . .');
  });
}
iniciar(); //Ejecuta iniciar, para que simpre se ejecute.