var DataTable; //Variable para dataTable.
var ajaxFile = 'inicio'; //Variable para archivo de ajax.

//Funcion que se ejecuta al inicio
function iniciar(){
  listarRegistros();
  AvisoExistencia();
}

function listarRegistros(){
  DataTable = $('#DataTable').dataTable({
    "aProcessing": true, //Activa el prosedamietno del datatables
    "aServerSide": true, //Paginacion y filtrado realizados por el servidor
    dom: 'Bfrtip', //Definimos los elementos del control de tabla
    buttons:['copyHtml5','excelHtml5','csvHtml5','pdf'],
    "ajax":{
      url: 'ajax/' +ajaxFile+ '.php?op=listar', //Obtener los valores desde url
      type: "get",
      dataType: "json", //Datos codificados mediante json
      error:function(e){ //en caso de errores
	//console.log(e.responseText);
      }
    },    
    "bBestroy": true,
    "iDisplayLength": 10, //Paginacion de X en X registros.
    "order": [[1, "desc"]] //Ordenar (columna,orden).
  }).DataTable();
}

function AvisoExistencia(){
  //console.log('AvisoExistencia');
  var jqxhr = $.post('ajax/' +ajaxFile+ ".php?op=AvisoExistencia", function (r){
    //console.log(r);
    if(r !== ''){
      toastr.warning('Avisos de poca existencia en producto');
    }
  })
  .done(function(r) {
    $("#AvisoExistencia").html(r); //Limpia
  })
  .fail(function(r) {
    console.log(r);
    toastr.error('jQuery AvisoExistencia . . .');
  });
}

iniciar(); //Ejecuta iniciar, para que simpre se ejecute.