var DataTable; //Variable para dataTable.
var Swal, toastr; //Varible de alertas
var ajaxFile = 'salidaProducto'; //Variable para archivo de ajax.
var camposForm = ['codigobarras','cantidadproducto','descripcion','notasalida'];
//Funcion que se ejecuta al inicio
function iniciar(){
  $('#formularioX').on('submit',function(e){ //si se activa el evento submit llamma funcion ...
    guardaryeditar(e);
  });  
  limpiar();
  listaEventos();
  buscarElementoSelect2();
}

function limpiar(){
  //Se usa Gquery $("#NombreDelObjeto).val("Valor a mandar");
  for(var i=0; i<camposForm.length; i++){
    $("#"+camposForm[i]).val(null);
  }
  $('#divFormulario').slideToggle( "slow" ); //Salida
}

function mostrarDiv(div, limpia = 0){
  if(limpia) limpiar();
  $( '#'+div ).slideDown('slow'); //Entrada
}

function guardaryeditar(e){
  e.preventDefault(); //Para que no se active la accion predeterminad del evento
  
  //$("#btnGuardar").prop("disabled",true);
  var formDatos = new FormData($("#formularioX")[0]); //Para obtener los datos del id=formularioX
  $.ajax({ //Metodo ajax
    url: "ajax/" +ajaxFile+ ".php?op=guardaryeditar", //archivo donde lo envia
    type: "POST",
    data: formDatos, //La varible var formData = new FormData mas arriba
    contentType: false,
    processData: false,
        
    success: function(respuesta){
      console.log(respuesta); // Ver consulta
      
      var separar = respuesta.split(','); //Separa en arreglo Var1,Var2,etc..
      if(separar[0] === 'success'){ toastr.success(separar[1]); }
      if(separar[0] === 'warning'){ toastr.success(separar[1]); }
      if(separar[0] === 'error'){ 
        console.log(respuesta);
        toastr.error(separar[1]);
      }      
      //DataTable.ajax.reload();
    }
  });  
  limpiar();
  listaEventos();
}

//Validar la existencia de un codigo similar....
function validaCodigo(){
//$('#codigobarras').change(function() {
  var clave = $("#codigobarras").val();
    
  //Si clave es mayor que # y exite un provvedor seleccionado
  if(clave.length > 0){
    //Mandar los datos ajax por GET $.get o POST $.post
    $.get("ajax/" +ajaxFile+ ".php?op=validaCodigo",{ clave:clave }, function(data, status){
      
      //var separar = data.split('#R'); //Separa en arreglo Var1,Var2,etc..
      $('#descripcion').val(data);      
      //console.log(data);
      
      if(data !== ''){        
        toastr.info('Se encontraron codigo ' +clave+ ' de producto existente, verifique el producto.');
      }else{
        toastr.warning('No se encontraron codigo ' +clave+ ' verifique el producto.');
      }
        
    });
  }
}
//});

function listaEventos(){
  //$('#divEventos').fadeIn(2000);
  $('.listaEventos').remove(); //Borrar etiquetas extras 
  
  $.get("ajax/" +ajaxFile+ ".php?op=listaEventos", function(data, status){
    //console.log(data);
    $('#listaEventos').append(data); //Agrega html a id
  });
}

$('#btnCancelar').click(function(){
  limpiar();
});

function buscarElementoSelect2(){
  // https://obedalvarado.pw/blog/autocomplete-select2-usando-jquery-ajax-php-y-mysql/
  // https://select2.org/data-sources/ajax
  $('#BuscaProducto').select2({
    minimumInputLength: 1,
    placeholder: 'Busqueda de producto...',
    ajax: {
      url: function (params) {
        return 'ajax/' +ajaxFile+ '.php?op=Select2&term='+params.term;
      },
      type: "POST",
      dataType: 'json',
      delay: 250,
      processResults: function (data) {
        return {          
          results: data,
        };
      },
      error:function(data){ //en caso de errores
        console.log(data.responseText);
      },
      //cache: true
    }
  }).on('select2:select', function (e) {
    var data = e.params.data;
    $("#codigobarras").val(data.id);
    //console.log(data.id);
    validaCodigo();
  });
}

iniciar(); //Ejecuta iniciar, para que simpre se ejecute.